/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.StreamDebugUtils;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.StateInitializer;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.platform.state.signed.SigSet;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

public final class SignedStateFileReader {
    private SignedStateFileReader() {
    }

    @NonNull
    public static DeserializedSignedState readStateFile(@NonNull Path stateFile, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull PlatformStateFacade stateFacade, @NonNull PlatformContext platformContext) throws IOException {
        Objects.requireNonNull(stateFile);
        Objects.requireNonNull(platformContext);
        Configuration conf = platformContext.getConfiguration();
        SignedStateFileReader.checkSignedStatePath(stateFile);
        MerkleTreeSnapshotReader.StateFileData data = MerkleTreeSnapshotReader.readStateFileData((Path)stateFile);
        File sigSetFile = stateFile.getParent().resolve("signatureSet.bin").toFile();
        SigSet sigSet = (SigSet)StreamDebugUtils.deserializeAndDebugOnFailure(() -> new BufferedInputStream(new FileInputStream(sigSetFile)), in -> {
            SignedStateFileReader.readAndCheckSigSetFileVersion(in);
            return (SigSet)in.readSerializable();
        });
        MerkleNodeState merkleNodeState = StateInitializer.initializeMerkleNodeState(createStateFromVirtualMap, data.stateRoot(), platformContext.getMetrics());
        SignedState newSignedState = new SignedState(conf, CryptoStatic::verifySignature, merkleNodeState, "SignedStateFileReader.readStateFile()", false, false, false, stateFacade);
        newSignedState.init(platformContext);
        SignedStateFileReader.registerServiceStates(newSignedState);
        newSignedState.setSigSet(sigSet);
        DeserializedSignedState returnState = new DeserializedSignedState(newSignedState.reserve("SignedStateFileReader.readStateFile()"), data.hash());
        return returnState;
    }

    private static void checkSignedStatePath(@NonNull Path stateFile) throws IOException {
        if (!Files.exists(stateFile, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(stateFile.toAbsolutePath()) + " does not exist!");
        }
        if (!Files.isRegularFile(stateFile, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(stateFile.toAbsolutePath()) + " is not a file!");
        }
    }

    private static void readAndCheckSigSetFileVersion(@NonNull MerkleDataInputStream in) throws IOException {
        int fileVersion = in.readInt();
        if (!SignedStateFileUtils.SUPPORTED_SIGSET_VERSIONS.contains(fileVersion)) {
            throw new IOException("Unsupported file version: " + fileVersion);
        }
        in.readProtocolVersion();
    }

    public static void registerServiceStates(@NonNull SignedState signedState) {
        SignedStateFileReader.registerServiceStates(signedState.getState());
    }

    public static void registerServiceStates(@NonNull MerkleNodeState state) {
        SignedStateFileReader.registerServiceState(state, new V0540PlatformStateSchema(), "PlatformStateService");
        SignedStateFileReader.registerServiceState(state, new V0540RosterBaseSchema(), "RosterService");
    }

    private static void registerServiceState(@NonNull MerkleNodeState state, @NonNull Schema<SemanticVersion> schema, @NonNull String name) {
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            StateMetadata md = new StateMetadata(name, def);
            if (!def.singleton() && !def.onDisk()) {
                throw new IllegalStateException("Only singletons and onDisk virtual maps are supported as stub states");
            }
            state.initializeState(md);
        });
    }

    public static void unregisterServiceStates(@NonNull SignedState signedState) {
        MerkleNodeState state = signedState.getState();
        state.unregisterService("PlatformStateService");
        state.unregisterService("RosterService");
    }
}

