/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFailurePayload;
import com.swirlds.logging.legacy.payload.ReconnectFinishPayload;
import com.swirlds.logging.legacy.payload.ReconnectStartPayload;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.reconnect.ReconnectException;
import com.swirlds.platform.reconnect.ReconnectLearner;
import com.swirlds.platform.reconnect.ReconnectLearnerFactory;
import com.swirlds.platform.reconnect.ReconnectNetworkHelper;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.base.concurrent.locks.locked.LockedResource;

public class ReconnectSyncHelper
implements ReconnectNetworkHelper {
    private static final Logger logger = LogManager.getLogger(ReconnectSyncHelper.class);
    private final java.util.function.Supplier<MerkleNodeState> workingStateSupplier;
    private final LongSupplier lastCompleteRoundSupplier;
    private final ReconnectLearnerFactory reconnectLearnerFactory;
    private final StateConfig stateConfig;
    private final PlatformStateFacade platformStateFacade;
    private final BlockingResourceProvider<Connection> connectionProvider = new BlockingResourceProvider();

    public ReconnectSyncHelper(@NonNull java.util.function.Supplier<MerkleNodeState> workingStateSupplier, @NonNull LongSupplier lastCompleteRoundSupplier, @NonNull ReconnectLearnerFactory reconnectLearnerFactory, @NonNull StateConfig stateConfig, @NonNull PlatformStateFacade platformStateFacade) {
        this.workingStateSupplier = Objects.requireNonNull(workingStateSupplier);
        this.lastCompleteRoundSupplier = Objects.requireNonNull(lastCompleteRoundSupplier);
        this.reconnectLearnerFactory = Objects.requireNonNull(reconnectLearnerFactory);
        this.stateConfig = Objects.requireNonNull(stateConfig);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
    }

    @Override
    @NonNull
    public ReservedSignedState receiveSignedState(@NonNull SignedStateValidator validator) throws ReconnectException, InterruptedException {
        ReservedSignedState reservedSignedState;
        block11: {
            Connection connection = null;
            LockedResource conn = this.connectionProvider.waitForResource();
            try {
                ReservedSignedState reservedState;
                connection = (Connection)conn.getResource();
                reservedSignedState = reservedState = this.reconnectLearner(connection, validator);
                if (conn == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    if (Utilities.isOrCausedBySocketException(e)) {
                        logger.error(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectFailurePayload("Got socket exception while receiving a signed state! " + NetworkUtils.formatException(e), ReconnectFailurePayload.CauseOfFailure.SOCKET).toString());
                    } else if (connection != null) {
                        connection.disconnect();
                    }
                    throw e;
                }
            }
            conn.close();
        }
        return reservedSignedState;
    }

    @NonNull
    private ReservedSignedState reconnectLearner(@NonNull Connection conn, @NonNull SignedStateValidator validator) throws ReconnectException {
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectStartPayload("Starting reconnect in role of the receiver.", true, conn.getSelfId().id(), conn.getOtherId().id(), this.lastCompleteRoundSupplier.getAsLong()).toString());
        ReconnectLearner reconnect = this.reconnectLearnerFactory.create(conn, this.workingStateSupplier.get());
        ReservedSignedState reservedState = reconnect.execute(validator);
        long lastRoundReceived = reservedState.get().getRound();
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFinishPayload("Finished reconnect in the role of the receiver.", true, conn.getSelfId().id(), conn.getOtherId().id(), lastRoundReceived).toString());
        logger.info(LogMarker.RECONNECT.getMarker(), "Information for state received during reconnect:\n{}", new Supplier[]{() -> this.platformStateFacade.getInfoString((State)reservedState.get().getState(), this.stateConfig.debugHashDepth())});
        return reservedState;
    }

    public void provideLearnerConnection(@NonNull Connection connection) throws InterruptedException {
        this.connectionProvider.provide((Object)connection);
    }

    public boolean acquireLearnerPermit() {
        return this.connectionProvider.acquireProvidePermit();
    }

    public boolean blockLearnerPermit() {
        return this.connectionProvider.tryBlockProvidePermit();
    }

    public void cancelLearnerPermit() {
        this.connectionProvider.releaseProvidePermit();
    }
}

