/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.freeze.FreezePeriodChecker;
import com.swirlds.platform.metrics.TransactionMetrics;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.SwirldStateManagerUtils;
import com.swirlds.platform.state.TransactionHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.merkle.StateMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public class SwirldStateManager
implements FreezePeriodChecker {
    private final TransactionMetrics transactionMetrics;
    private final StateMetrics stateMetrics;
    private final AtomicReference<MerkleNodeState> stateRef = new AtomicReference();
    private final AtomicReference<MerkleNodeState> latestImmutableState = new AtomicReference();
    private final TransactionHandler transactionHandler;
    private final SemanticVersion softwareVersion;
    private final ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler;
    private final PlatformStateFacade platformStateFacade;

    public SwirldStateManager(@NonNull PlatformContext platformContext, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull StatusActionSubmitter statusActionSubmitter, @NonNull SemanticVersion softwareVersion, @NonNull ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(roster);
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(consensusStateEventHandler);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        this.consensusStateEventHandler = consensusStateEventHandler;
        this.transactionMetrics = new TransactionMetrics(platformContext.getMetrics());
        this.stateMetrics = new StateMetrics(platformContext.getMetrics());
        Objects.requireNonNull(statusActionSubmitter);
        this.softwareVersion = Objects.requireNonNull(softwareVersion);
        this.transactionHandler = new TransactionHandler(selfId, this.transactionMetrics);
    }

    public void setInitialState(@NonNull MerkleNodeState state) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        if (this.stateRef.get() != null) {
            throw new IllegalStateException("Attempt to set initial state when there is already a state reference.");
        }
        this.fastCopyAndUpdateRefs(state);
    }

    public Queue<ScopedSystemTransaction<StateSignatureTransaction>> handleConsensusRound(ConsensusRound round) {
        MerkleNodeState state = this.stateRef.get();
        return this.transactionHandler.handleRound(round, this.consensusStateEventHandler, state);
    }

    public boolean sealConsensusRound(@NonNull Round round) {
        Objects.requireNonNull(round);
        MerkleNodeState state = this.stateRef.get();
        return this.consensusStateEventHandler.onSealConsensusRound(round, state);
    }

    public MerkleNodeState getConsensusState() {
        return this.stateRef.get();
    }

    public void savedStateInFreezePeriod() {
        this.platformStateFacade.updateLastFrozenTime((State)this.stateRef.get());
    }

    public void loadFromSignedState(@NonNull SignedState signedState) {
        MerkleNodeState state = signedState.getState();
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        this.fastCopyAndUpdateRefs(state);
    }

    private void fastCopyAndUpdateRefs(MerkleNodeState state) {
        MerkleNodeState newState = SwirldStateManagerUtils.fastCopy(state, this.stateMetrics, this.softwareVersion, this.platformStateFacade);
        this.setLatestImmutableState(state);
        this.setState(newState);
    }

    private void setState(MerkleNodeState state) {
        MerkleNodeState currVal = this.stateRef.get();
        if (currVal != null) {
            currVal.release();
        }
        this.stateRef.set(state);
    }

    private void setLatestImmutableState(MerkleNodeState immutableState) {
        State currVal = (State)this.latestImmutableState.get();
        if (currVal != null) {
            currVal.release();
        }
        immutableState.getRoot().reserve();
        this.latestImmutableState.set(immutableState);
    }

    @Override
    public boolean isInFreezePeriod(Instant timestamp) {
        return PlatformStateFacade.isInFreezePeriod(timestamp, this.platformStateFacade.freezeTimeOf((State)this.getConsensusState()), this.platformStateFacade.lastFrozenTimeOf((State)this.getConsensusState()));
    }

    public MerkleNodeState getStateForSigning() {
        this.fastCopyAndUpdateRefs(this.stateRef.get());
        return this.latestImmutableState.get();
    }
}

