/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.metrics.TransactionMetrics;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.state.MerkleNodeState;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public class TransactionHandler {
    private static final Logger logger = LogManager.getLogger(TransactionHandler.class);
    private final NodeId selfId;
    private final TransactionMetrics stats;

    public TransactionHandler(NodeId selfId, TransactionMetrics stats) {
        this.selfId = selfId;
        this.stats = stats;
    }

    public <T extends MerkleNodeState> Queue<ScopedSystemTransaction<StateSignatureTransaction>> handleRound(ConsensusRound round, ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler, T stateRoot) {
        ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>> scopedSystemTransactions = new ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>>();
        try {
            Instant timeOfHandle = Instant.now();
            long startTime = System.nanoTime();
            consensusStateEventHandler.onHandleConsensusRound((Round)round, stateRoot, scopedSystemTransactions::add);
            double secondsElapsed = (double)(System.nanoTime() - startTime) * 1.0E-9;
            if (round.getNumAppTransactions() == 0) {
                this.stats.consensusTransHandleTime(secondsElapsed);
            } else {
                this.stats.consensusTransHandleTime(secondsElapsed / (double)round.getNumAppTransactions());
            }
            this.stats.consensusTransHandled(round.getNumAppTransactions());
            this.stats.consensusToHandleTime((double)round.getReachedConsTimestamp().until(timeOfHandle, ChronoUnit.NANOS) * 1.0E-9);
        }
        catch (Throwable t) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error invoking ConsensusStateEventHandler.onHandleConsensusRound() [ nodeId = {} ] with round {}", (Object)this.selfId, (Object)round.getRoundNum(), (Object)t);
        }
        return scopedSystemTransactions;
    }
}

