/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.MerkleProof;
import com.swirlds.state.SiblingHash;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateItem;
import com.swirlds.state.merkle.StateKeyUtils;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.merkle.disk.OnDiskReadableKVState;
import com.swirlds.state.merkle.disk.OnDiskReadableQueueState;
import com.swirlds.state.merkle.disk.OnDiskReadableSingletonState;
import com.swirlds.state.merkle.disk.OnDiskWritableKVState;
import com.swirlds.state.merkle.disk.OnDiskWritableQueueState;
import com.swirlds.state.merkle.disk.OnDiskWritableSingletonState;
import com.swirlds.state.merkle.disk.QueueState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.Path;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;

public abstract class VirtualMapState<T extends VirtualMapState<T>>
implements MerkleNodeState {
    public static final String VM_LABEL = "state";
    private static final Logger logger = LogManager.getLogger(VirtualMapState.class);
    protected final Map<String, Map<Integer, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private final Metrics metrics;
    protected VirtualMap virtualMap;
    private boolean startupMode = true;

    public VirtualMapState(@NonNull Configuration configuration, @NonNull Metrics metrics) {
        Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, merkleDbConfig.initialCapacity(), merkleDbConfig.hashesRamToDiskThreshold());
        this.virtualMap = new VirtualMap(VM_LABEL, (VirtualDataSourceBuilder)dsBuilder, configuration);
        this.virtualMap.registerMetrics(metrics);
    }

    public VirtualMapState(@NonNull VirtualMap virtualMap, @NonNull Metrics metrics) {
        this.virtualMap = Objects.requireNonNull(virtualMap);
        this.metrics = Objects.requireNonNull(metrics);
    }

    protected VirtualMapState(@NonNull VirtualMapState<T> from) {
        this.virtualMap = from.virtualMap.copy();
        this.metrics = from.metrics;
        this.startupMode = from.startupMode;
        this.listeners.addAll(from.listeners);
        for (Map.Entry<String, Map<Integer, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
    }

    protected abstract T copyingConstructor();

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.virtualMap.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public T copy() {
        return this.copyingConstructor();
    }

    public void computeHash() {
        this.virtualMap.throwIfMutable("Hashing should only be done on immutable states");
        this.virtualMap.throwIfDestroyed("Hashing should not be done on destroyed states");
        this.virtualMap.getHash();
    }

    public void initializeState(@NonNull StateMetadata<?, ?> md) {
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(md);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateId(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
    }

    public void unregisterService(@NonNull String serviceName) {
        this.readableStatesMap.remove(serviceName);
        this.writableStatesMap.remove(serviceName);
        this.services.remove(serviceName);
    }

    public void removeServiceState(@NonNull String serviceName, int stateId) {
        MerkleWritableStates writableStates;
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(serviceName);
        Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.get(serviceName);
        if (stateMetadata != null) {
            stateMetadata.remove(stateId);
        }
        if ((writableStates = this.writableStatesMap.get(serviceName)) != null) {
            writableStates.remove(stateId);
        }
    }

    public Map<String, Map<Integer, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public boolean isStartUpMode() {
        return this.startupMode;
    }

    public void disableStartupMode() {
        this.startupMode = false;
    }

    public MerkleNode getRoot() {
        return this.virtualMap;
    }

    @Nullable
    public Hash getHash() {
        return this.virtualMap.getHash();
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("VirtualMap is self hashing");
    }

    public boolean isMutable() {
        return this.virtualMap.isMutable();
    }

    public boolean isImmutable() {
        return this.virtualMap.isImmutable();
    }

    public boolean isDestroyed() {
        return this.virtualMap.isDestroyed();
    }

    public boolean release() {
        return this.virtualMap.release();
    }

    public void close() {
        logger.info("Closing VirtualMapState");
        try {
            this.virtualMap.getDataSource().close();
        }
        catch (IOException e) {
            logger.warn("Unable to close data source for the Virtual Map", (Throwable)e);
        }
    }

    public void commitSingletons() {
        this.services.forEach((serviceKey, serviceStates) -> serviceStates.entrySet().stream().filter(stateMetadata -> ((StateMetadata)stateMetadata.getValue()).stateDefinition().singleton()).forEach(service -> {
            WritableStates writableStates = this.getWritableStates((String)serviceKey);
            WritableSingletonStateBase writableSingleton = (WritableSingletonStateBase)writableStates.getSingleton(((Integer)service.getKey()).intValue());
            writableSingleton.commit();
        }));
    }

    public long singletonPath(int stateId) {
        return this.virtualMap.getRecords().findPath(StateUtils.getStateKeyForSingleton(stateId));
    }

    public long queueElementPath(int stateId, @NonNull Bytes expectedValue) {
        StateValue queueStateValue = (StateValue)this.virtualMap.get(StateKeyUtils.queueStateKey(stateId), OnDiskQueueHelper.QUEUE_STATE_VALUE_CODEC);
        if (queueStateValue == null) {
            return -1L;
        }
        QueueState queueState = (QueueState)queueStateValue.value();
        for (long i = queueState.head(); i < queueState.tail(); ++i) {
            Bytes actualValue;
            Bytes stateKey = StateUtils.getStateKeyForQueue(stateId, i);
            VirtualLeafBytes leafRecord = this.virtualMap.getRecords().findLeafRecord(stateKey);
            if (leafRecord == null || !(actualValue = StateValue.StateValueCodec.unwrap(leafRecord.valueBytes())).equals((Object)expectedValue)) continue;
            return leafRecord.path();
        }
        return -1L;
    }

    public long kvPath(int stateId, @NonNull Bytes key) {
        return this.virtualMap.getRecords().findPath(StateKeyUtils.kvKey(stateId, key));
    }

    public Hash getHashForPath(long path) {
        return this.virtualMap.getRecords().findHash(path);
    }

    public MerkleProof getMerkleProof(long path) {
        if (!this.isHashed()) {
            throw new IllegalStateException("Cannot get Merkle proof for unhashed virtual map");
        }
        VirtualLeafBytes leafRecord = this.virtualMap.getRecords().findLeafRecord(path);
        if (leafRecord == null) {
            return null;
        }
        ArrayList<SiblingHash> siblingHashes = new ArrayList<SiblingHash>();
        ArrayList<Hash> innerParentHashes = new ArrayList<Hash>();
        long currentPath = path;
        while (currentPath > 0L) {
            long siblingPath = Path.getSiblingPath((long)currentPath);
            boolean isSiblingRight = Path.isRight((long)siblingPath);
            Hash hashForPath = this.getHashForPath(siblingPath);
            Hash normalizedHashForPath = hashForPath == null ? Cryptography.NULL_HASH : hashForPath;
            siblingHashes.add(new SiblingHash(isSiblingRight, normalizedHashForPath));
            innerParentHashes.add(this.getHashForPath(currentPath));
            currentPath = Path.getParentPath((long)currentPath);
        }
        assert (this.virtualMap.getHash() != null);
        innerParentHashes.add(this.virtualMap.getHash());
        StateItem stateItem = new StateItem(leafRecord.keyBytes(), leafRecord.valueBytes());
        return new MerkleProof(StateItem.CODEC.toBytes((Object)stateItem), siblingHashes, innerParentHashes);
    }

    public boolean isHashed() {
        return this.virtualMap.isHashed();
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(VirtualMapState.this, stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            return new OnDiskReadableKVState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractKeyCodec(md), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            return new OnDiskReadableSingletonState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md) {
            return new OnDiskReadableQueueState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(VirtualMapState.this, stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        public void copyAndReleaseVirtualMap(int stateId) {
            StateMetadata md = (StateMetadata)this.stateMetadata.get(stateId);
            VirtualMap mutableCopy = VirtualMapState.this.virtualMap.copy();
            mutableCopy.registerMetrics(VirtualMapState.this.metrics);
            VirtualMapState.this.virtualMap.release();
            VirtualMapState.this.virtualMap = mutableCopy;
            this.kvInstances.put(stateId, this.createReadableKVState(md));
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(int stateId) {
            return (WritableKVState)super.get(stateId);
        }

        @NonNull
        public <V> WritableSingletonState<V> getSingleton(int stateId) {
            return (WritableSingletonState)super.getSingleton(stateId);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(int stateId) {
            return (WritableQueueState)super.getQueue(stateId);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            OnDiskWritableKVState state = new OnDiskWritableKVState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractKeyCodec(md), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            OnDiskWritableSingletonState state = new OnDiskWritableSingletonState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md) {
            OnDiskWritableQueueState state = new OnDiskWritableQueueState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            this.kvInstances.keySet().stream().sorted().forEach(stateId -> ((WritableKVStateBase)this.kvInstances.get(stateId)).commit());
            if (VirtualMapState.this.startupMode) {
                this.singletonInstances.keySet().stream().sorted().forEach(stateId -> ((WritableSingletonStateBase)this.singletonInstances.get(stateId)).commit());
            }
            this.queueInstances.keySet().stream().sorted().forEach(stateId -> ((WritableQueueStateBase)this.queueInstances.get(stateId)).commit());
            VirtualMapState.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(int stateId) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateId);
            }
            this.kvInstances.remove(stateId);
            this.singletonInstances.remove(stateId);
            this.queueInstances.remove(stateId);
        }

        private <V> void registerSingletonListener(@NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = singletonState.getStateId();
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = queueState.getStateId();
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = state.getStateId();
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private abstract class MerkleStates
    implements ReadableStates {
        protected final Map<Integer, StateMetadata<?, ?>> stateMetadata;
        protected final Map<Integer, ReadableKVState<?, ?>> kvInstances;
        protected final Map<Integer, ReadableSingletonState<?>> singletonInstances;
        protected final Map<Integer, ReadableQueueState<?>> queueInstances;
        private final Set<Integer> stateIds;

        MerkleStates(@NonNull VirtualMapState virtualMapState, Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateIds = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(int stateId) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().onDisk()) {
                throw new IllegalArgumentException("Unknown k/v state ID '" + stateId + ";");
            }
            ReadableKVState ret = this.createReadableKVState(md);
            this.kvInstances.put(stateId, ret);
            return ret;
        }

        @NonNull
        public <V> ReadableSingletonState<V> getSingleton(int stateId) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state ID '" + stateId + "'");
            }
            ReadableSingletonState ret = this.createReadableSingletonState(md);
            this.singletonInstances.put(stateId, ret);
            return ret;
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(int stateId) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state ID '" + stateId + "'");
            }
            ReadableQueueState ret = this.createReadableQueueState(md);
            this.queueInstances.put(stateId, ret);
            return ret;
        }

        public boolean contains(int stateId) {
            return this.stateMetadata.containsKey(stateId);
        }

        @NonNull
        public Set<Integer> stateIds() {
            return this.stateIds;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1);

        static int extractStateId(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().stateId();
        }

        @NonNull
        static String extractStateKey(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().stateKey();
        }

        @NonNull
        static <K> Codec<K> extractKeyCodec(@NonNull StateMetadata<K, ?> md) {
            return Objects.requireNonNull(md.stateDefinition().keyCodec(), "Key codec is null");
        }

        @NonNull
        static <V> Codec<V> extractValueCodec(@NonNull StateMetadata<?, V> md) {
            return md.stateDefinition().valueCodec();
        }
    }
}

