/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.base.utility.Pair;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.utility.throttle.Throttle;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.system.Platform;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class FCMQueryController {
    private static final Logger logger = LogManager.getLogger(FCMQueryController.class);
    private final Platform platform;
    private final int numberOfThreads;
    private final Throttle throttle;
    private static final SpeedometerMetric.Config FCM_QUERIES_ANSWERED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("FCM", "fcmQueriesAnsweredPerSecond").withDescription("number of FCM queries have been answered per second").withFormat("%,9.6f");
    private final SpeedometerMetric fcmQueriesAnsweredPerSecond;

    public FCMQueryController(FCMConfig.FCMQueryConfig fcmQueryConfig, Platform platform) {
        this.platform = platform;
        this.numberOfThreads = fcmQueryConfig.getNumberOfThreads();
        this.throttle = new Throttle((double)fcmQueryConfig.getQps());
        this.fcmQueriesAnsweredPerSecond = (SpeedometerMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)FCM_QUERIES_ANSWERED_PER_SECOND_CONFIG);
    }

    public void launch() {
        ExecutorService queryThreadPool = Executors.newFixedThreadPool(this.numberOfThreads);
        for (int index = 0; index < this.numberOfThreads; ++index) {
            queryThreadPool.execute(this::execute);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void execute() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                if (!this.throttle.allow()) {
                    Thread.onSpinWait();
                    continue;
                }
                stateWrapper = this.platform.getLatestImmutableState("FCMQueryController.execute()");
                try {
                    state = (PlatformTestingToolState)stateWrapper.get();
                    if (state == null) ** GOTO lbl-1000
                    this.executeFCMQuery(state);
                }
                finally {
                    if (stateWrapper == null) continue;
                    stateWrapper.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            FCMQueryController.logger.error(LogMarker.EXCEPTION.getMarker(), "exception on query thread", (Throwable)ex);
            return;
        }
        ** GOTO lbl-1000
    }

    private void executeFCMQuery(PlatformTestingToolState state) {
        Optional<Pair<MapKey, MapValueData>> optionalPair = this.getRandomValue(state);
        if (optionalPair.isEmpty()) {
            return;
        }
        Pair<MapKey, MapValueData> pair = optionalPair.get();
        MapKey key = (MapKey)pair.key();
        MapValueData data = (MapValueData)pair.value();
        ExpectedFCMFamily expectedFamily = state.getStateExpectedMap();
        ExpectedValue expectedValue = expectedFamily.getExpectedMap().get(key);
        if (expectedValue.getUid() != data.getUid()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Value for key {} doesn't have matching value {} != {}", (Object)key, (Object)expectedValue.getUid(), (Object)data.getUid());
        }
        this.fcmQueriesAnsweredPerSecond.update(1.0);
    }

    private Optional<Pair<MapKey, MapValueData>> getRandomValue(PlatformTestingToolState state) {
        MapKey key = state.getStateExpectedMap().getMapKeyForFCMTx(TransactionType.Update, EntityType.Crypto, false, false, 0);
        if (key == null) {
            return Optional.empty();
        }
        MapValueData data = (MapValueData)state.getStateMap().getMap().get((Object)key);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)key, (Object)data));
    }
}

