/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.MetricType;
import com.swirlds.metrics.api.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;

public interface LongGauge
extends Metric {
    @Override
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    @NonNull
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    @NonNull
    default public Long get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public long get();

    public void set(long var1);

    public void add(long var1);

    public static final class Config
    extends MetricConfig<LongGauge, Config> {
        private final long initialValue;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
            this.initialValue = 0L;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, long initialValue) {
            super(category, name, description, unit, format);
            this.initialValue = initialValue;
        }

        @Override
        @NonNull
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getInitialValue());
        }

        @Override
        @NonNull
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getInitialValue());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getInitialValue());
        }

        public long getInitialValue() {
            return this.initialValue;
        }

        @NonNull
        public Config withInitialValue(long initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), initialValue);
        }

        @Override
        @NonNull
        public Class<LongGauge> getResultClass() {
            return LongGauge.class;
        }

        @Override
        @NonNull
        public LongGauge create(@NonNull MetricsFactory factory) {
            return factory.createLongGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

