/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.transaction;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import org.hiero.consensus.model.transaction.ConsensusTransaction;

public non-sealed class TransactionWrapper
implements ConsensusTransaction {
    private Instant consensusTimestamp;
    private Object metadata;
    private Bytes hash;
    private final Bytes transaction;

    public TransactionWrapper(@NonNull Bytes payloadBytes) {
        this.transaction = payloadBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionWrapper that = (TransactionWrapper)o;
        return Objects.equals(this.getApplicationTransaction(), that.getApplicationTransaction());
    }

    public int hashCode() {
        return Objects.hash(this.getApplicationTransaction());
    }

    @Override
    @Nullable
    public Instant getConsensusTimestamp() {
        return this.consensusTimestamp;
    }

    public void setConsensusTimestamp(@NonNull Instant consensusTimestamp) {
        this.consensusTimestamp = consensusTimestamp;
    }

    @Override
    @NonNull
    public Bytes getApplicationTransaction() {
        return this.transaction;
    }

    @Override
    public long getSize() {
        return this.transaction.length();
    }

    @Override
    @Nullable
    public <T> T getMetadata() {
        return (T)this.metadata;
    }

    @Override
    public <T> void setMetadata(@Nullable T metadata) {
        this.metadata = metadata;
    }

    public void setHash(@NonNull Bytes hash) {
        this.hash = Objects.requireNonNull(hash, "hash should not be null");
    }

    @NonNull
    public Bytes getHash() {
        return Objects.requireNonNull(this.hash, "hash should not be null");
    }
}

