/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli;

import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.CommandBuilder;
import com.swirlds.cli.utility.PlatformCliLogo;
import com.swirlds.cli.utility.PlatformCliPreParser;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.startup.Log4jSetup;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import picocli.CommandLine;

@CommandLine.Command(name="pcli", version={"0.34.0"}, mixinStandardHelpOptions=true, description={"Miscellaneous platform utilities."})
public class PlatformCli
extends AbstractCommand {
    private static final String DOCUMENTATION_PURPOSES_ONLY = "This argument is included here for documentation purposes only.";

    @CommandLine.Option(names={"-L", "--load", "--cp"}, scope=CommandLine.ScopeType.INHERIT, description={"A path where additional java libs should be loaded from. Can be a path to a jar file or a path to a directory containing jar files."})
    private void setLoadPath(List<Path> loadPath) {
        throw this.buildParameterException("The load path parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-J", "--jvm"}, scope=CommandLine.ScopeType.INHERIT, description={"An argument that will be passed to the JVM, e.g. '-Xmx10g'"})
    private void setJvmArgs(List<String> jvmArgs) {
        throw this.buildParameterException("The jvm args parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-C", "--cli"}, scope=CommandLine.ScopeType.INHERIT, description={"A package prefix where CLI commands/subcommands can be found. Commands annotated with '@SubcommandOf' in these packages are automatically integrated into pcli."})
    private void setCliPackagePrefixes(List<String> cliPackagePrefixes) {
        throw this.buildParameterException("The cli parameter is expected to be parsed using a different pathway. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-D", "--debug"}, scope=CommandLine.ScopeType.INHERIT, description={"Pause the JVM at startup, and wait until a debugger is attached to port 8888 before continuing."})
    private void setDebug(boolean debug) {
        throw this.buildParameterException("The debug parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-M", "--memory"}, scope=CommandLine.ScopeType.INHERIT, description={"Set the amount of memory to allocate to the JVM, in gigabytes. '-M 16' is equivalent to '-J -Xmx16g'."})
    private void setJvmArgs(int memory) {
        throw this.buildParameterException("The memory parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"--log4j"}, scope=CommandLine.ScopeType.INHERIT, description={"The path where the log4j configuration file can be found."})
    private void setLog4jPath(Path log4jPath) {
        throw this.buildParameterException("The log4j path parameter is expected to be parsed manually. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"--no-color"}, description={"Disable color output. This option is designed for boring people living boring lives, who want their console output to be just as boring as they are."})
    private void setColorDisabled(boolean colorDisabled) {
        throw this.buildParameterException("The setColorDisabled parameter is expected to be parsed manually. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-I", "--ignore-jars"}, scope=CommandLine.ScopeType.INHERIT, description={"If running in a platform development environment, if this flag is present then ignore jar files in the standard platform sdk/data/lib directory. This can be useful if running on a machine with a platform build environment, but where you don't want to load the jars from that build environment. If not running in a platform development environment, this flag has no effect"})
    private void setIgnoreJars(boolean ignoreJars) {
        throw this.buildParameterException("The ignore jars parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-B", "--bootstrap"}, scope=CommandLine.ScopeType.INHERIT, description={"The fully qualified name of the function to run before the command is executed.Can be used to do arbitrary bootstrapping. Should be a static method that implements the interface Runnable. e.g. '-B com.swirlds.cli.utility.PlatformCliPreParser.exampleBootstrapFunction'"})
    private void setBoostrapFunction(String boostrapFunction) {
        throw this.buildParameterException("This argument is parsed by the pre-parser. This argument is included here for documentation purposes only.");
    }

    private static PlatformCliPreParser preParse(String[] args) {
        CommandLine commandLine = new CommandLine(PlatformCliPreParser.class);
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.execute(args);
        List unmatchedArgs = commandLine.getUnmatchedArguments();
        PlatformCliPreParser parser = (PlatformCliPreParser)commandLine.getCommand();
        parser.setUnparsedArgs(unmatchedArgs.toArray(new String[0]));
        return parser;
    }

    public static void main(String[] args) throws InterruptedException {
        PlatformCliPreParser preParser = PlatformCli.preParse(args);
        TextEffect.setTextEffectsEnabled((!preParser.isColorDisabled() ? 1 : 0) != 0);
        System.out.println(PlatformCliLogo.getColorizedLogo());
        CountDownLatch log4jLatch = Log4jSetup.startLoggingFramework((Path)preParser.getLog4jPath());
        preParser.runBootstrapFunction();
        CommandBuilder.whitelistCliPackage("com.swirlds.platform.cli");
        CommandBuilder.whitelistCliPackage("com.swirlds.platform.state.editor");
        if (preParser.getCliPackagePrefixes() != null) {
            for (String cliPackagePrefix : preParser.getCliPackagePrefixes()) {
                CommandBuilder.whitelistCliPackage(cliPackagePrefix);
            }
        }
        CommandLine commandLine = CommandBuilder.buildCommandLine(PlatformCli.class);
        log4jLatch.await();
        System.exit(commandLine.execute(preParser.getUnparsedArgs()));
    }
}

