/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.ReconnectStateLoader;
import com.swirlds.platform.StateInitializer;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.components.DefaultAppNotifier;
import com.swirlds.platform.components.DefaultEventWindowManager;
import com.swirlds.platform.components.DefaultSavedStateController;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.consensus.EventWindowUtils;
import com.swirlds.platform.event.EventCounter;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFileTracker;
import com.swirlds.platform.event.preconsensus.PcesMultiFileIterator;
import com.swirlds.platform.event.preconsensus.PcesReplayer;
import com.swirlds.platform.metrics.RuntimeMetrics;
import com.swirlds.platform.publisher.DefaultPlatformPublisher;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.SwirldStateManager;
import com.swirlds.platform.state.address.RosterMetrics;
import com.swirlds.platform.state.nexus.DefaultLatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.LockFreeStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.DefaultStateSignatureCollector;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateMetrics;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.state.snapshot.StateDumpRequest;
import com.swirlds.platform.state.snapshot.StateToDiskReason;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.platform.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;

public class SwirldsPlatform
implements Platform {
    private static final Logger logger = LogManager.getLogger(SwirldsPlatform.class);
    private final NodeId selfId;
    private final Roster currentRoster;
    private final KeysAndCerts keysAndCerts;
    private final long initialAncientThreshold;
    private final long startingRound;
    private final SignedStateNexus latestImmutableStateNexus = new LockFreeStateNexus();
    private final NotificationEngine notificationEngine;
    private final PlatformContext platformContext;
    private final PcesFileTracker initialPcesFiles;
    private final SavedStateController savedStateController;
    private final PlatformComponents platformComponents;
    private final long pcesReplayLowerBound;
    private final PlatformCoordinator platformCoordinator;

    public SwirldsPlatform(@NonNull PlatformComponentBuilder builder) {
        PlatformBuildingBlocks blocks = builder.getBuildingBlocks();
        this.platformContext = blocks.platformContext();
        ConsensusStateEventHandler consensusStateEventHandler = blocks.consensusStateEventHandler();
        SignedState initialState = blocks.initialState().get();
        PlatformStateFacade platformStateFacade = blocks.platformStateFacade();
        this.selfId = blocks.selfId();
        InlinePcesWriter inlinePcesWriter = null;
        this.initialPcesFiles = blocks.initialPcesFiles();
        this.notificationEngine = blocks.notificationEngine();
        logger.info(LogMarker.STARTUP.getMarker(), "Starting with roster history:\n{}", (Object)blocks.rosterHistory());
        this.currentRoster = blocks.rosterHistory().getCurrentRoster();
        RosterMetrics.registerRosterMetrics(this.platformContext.getMetrics(), this.currentRoster, this.selfId);
        RuntimeMetrics.setup(this.platformContext.getMetrics());
        this.keysAndCerts = blocks.keysAndCerts();
        EventCounter.registerEventCounterMetrics(this.platformContext.getMetrics());
        DefaultLatestCompleteStateNexus latestCompleteStateNexus = new DefaultLatestCompleteStateNexus(this.platformContext);
        this.savedStateController = new DefaultSavedStateController(this.platformContext);
        SignedStateMetrics signedStateMetrics = new SignedStateMetrics(this.platformContext.getMetrics());
        DefaultStateSignatureCollector stateSignatureCollector = new DefaultStateSignatureCollector(this.platformContext, signedStateMetrics);
        this.platformComponents = blocks.platformComponents();
        this.platformCoordinator = new PlatformCoordinator(blocks.platformComponents());
        blocks.statusActionSubmitterReference().set(this.platformCoordinator);
        Duration replayHealthThreshold = ((PcesConfig)this.platformContext.getConfiguration().getConfigData(PcesConfig.class)).replayHealthThreshold();
        PcesReplayer pcesReplayer = new PcesReplayer(this.platformContext, this.platformComponents.pcesReplayerWiring().eventOutput(), this.platformCoordinator::flushIntakePipeline, this.platformCoordinator::flushTransactionHandler, () -> this.latestImmutableStateNexus.getState("PCES replay"), () -> CompareTo.isLessThan((Comparable)blocks.model().getUnhealthyDuration(), (Object)replayHealthThreshold));
        StateInitializer.initializeState(this, this.platformContext, initialState, consensusStateEventHandler, platformStateFacade);
        SwirldStateManager swirldStateManager = blocks.swirldStateManager();
        swirldStateManager.setInitialState(initialState.getState());
        DefaultEventWindowManager eventWindowManager = new DefaultEventWindowManager();
        blocks.freezeCheckHolder().setFreezeCheckRef(swirldStateManager::isInFreezePeriod);
        DefaultAppNotifier appNotifier = new DefaultAppNotifier(blocks.notificationEngine());
        DefaultPlatformPublisher publisher = new DefaultPlatformPublisher(blocks.applicationCallbacks());
        this.platformComponents.bind(builder, pcesReplayer, stateSignatureCollector, eventWindowManager, inlinePcesWriter, this.latestImmutableStateNexus, latestCompleteStateNexus, this.savedStateController, appNotifier, publisher);
        Hash legacyRunningEventHash = platformStateFacade.legacyRunningEventHashOf((State)initialState.getState()) == null ? Cryptography.NULL_HASH : platformStateFacade.legacyRunningEventHashOf((State)initialState.getState());
        RunningEventHashOverride runningEventHashOverride = new RunningEventHashOverride(legacyRunningEventHash, false);
        this.platformCoordinator.updateRunningHash(runningEventHashOverride);
        String actualMainClassName = ((StateConfig)this.platformContext.getConfiguration().getConfigData(StateConfig.class)).getMainClassName(blocks.mainClassName());
        SignedStateFilePath statePath = new SignedStateFilePath((StateCommonConfig)this.platformContext.getConfiguration().getConfigData(StateCommonConfig.class));
        List<SavedStateInfo> savedStates = statePath.getSavedStateFiles(actualMainClassName, this.selfId, blocks.swirldName());
        if (!savedStates.isEmpty()) {
            long minimumGenerationNonAncientForOldestState = savedStates.get(savedStates.size() - 1).metadata().minimumBirthRoundNonAncient();
            this.platformCoordinator.injectPcesMinimumGenerationToStore(minimumGenerationNonAncientForOldestState);
        }
        boolean startedFromGenesis = initialState.isGenesisState();
        this.latestImmutableStateNexus.setState(initialState.reserve("set latest immutable to initial state"));
        if (startedFromGenesis) {
            this.initialAncientThreshold = 0L;
            this.startingRound = 0L;
            this.platformCoordinator.updateEventWindow(EventWindow.getGenesisEventWindow());
        } else {
            this.initialAncientThreshold = platformStateFacade.ancientThresholdOf((State)initialState.getState());
            this.startingRound = initialState.getRound();
            this.platformCoordinator.sendStateToHashLogger(initialState);
            this.platformCoordinator.injectSignatureCollectorState(initialState.reserve("loading initial state into sig collector"));
            this.savedStateController.registerSignedStateFromDisk(initialState);
            ConsensusSnapshot consensusSnapshot = Objects.requireNonNull(platformStateFacade.consensusSnapshotOf((State)initialState.getState()));
            this.platformCoordinator.consensusSnapshotOverride(consensusSnapshot);
            this.platformCoordinator.updateEventWindow(EventWindowUtils.createEventWindow(consensusSnapshot, this.platformContext.getConfiguration()));
            this.platformCoordinator.overrideIssDetectorState(initialState.reserve("initialize issDetector"));
        }
        blocks.getLatestCompleteStateReference().set(() -> latestCompleteStateNexus.getState("get latest complete state for reconnect"));
        ReconnectStateLoader reconnectStateLoader = new ReconnectStateLoader(this, this.platformContext, this.platformCoordinator, swirldStateManager, this.latestImmutableStateNexus, this.savedStateController, this.currentRoster, consensusStateEventHandler, platformStateFacade);
        blocks.loadReconnectStateReference().set(reconnectStateLoader::loadReconnectState);
        blocks.clearAllPipelinesForReconnectReference().set(this.platformCoordinator::clear);
        blocks.latestImmutableStateProviderReference().set(this.latestImmutableStateNexus::getState);
        this.pcesReplayLowerBound = !initialState.isGenesisState() ? this.initialAncientThreshold : 0L;
    }

    @Override
    @NonNull
    public NodeId getSelfId() {
        return this.selfId;
    }

    @Override
    public void start() {
        logger.info(LogMarker.STARTUP.getMarker(), "Starting platform {}", (Object)this.selfId);
        this.platformContext.getRecycleBin().start();
        this.platformContext.getMetrics().start();
        this.platformCoordinator.start();
        this.replayPreconsensusEvents();
        this.platformCoordinator.startGossip();
    }

    @Override
    public void destroy() throws InterruptedException {
        this.notificationEngine.shutdown();
        this.platformContext.getRecycleBin().stop();
        this.platformCoordinator.stop();
        StaticPlatformBuilder.getMetricsProvider().removePlatformMetrics(this.selfId);
    }

    public void performPcesRecovery() {
        this.platformContext.getRecycleBin().start();
        this.platformContext.getMetrics().start();
        this.platformCoordinator.start();
        this.replayPreconsensusEvents();
        try (ReservedSignedState reservedState = this.latestImmutableStateNexus.getState("Get PCES recovery state");){
            if (reservedState == null) {
                logger.warn(LogMarker.STATE_TO_DISK.getMarker(), "Trying to dump PCES recovery state to disk, but no state is available.");
            } else {
                SignedState signedState = reservedState.get();
                signedState.markAsStateToSave(StateToDiskReason.PCES_RECOVERY_COMPLETE);
                StateDumpRequest request = StateDumpRequest.create(signedState.reserve("dumping PCES recovery state"));
                this.platformCoordinator.dumpStateToDisk(request);
                request.waitForFinished().run();
            }
        }
    }

    private void replayPreconsensusEvents() {
        this.platformCoordinator.submitStatusAction(new StartedReplayingEventsAction());
        PcesMultiFileIterator iterator = this.initialPcesFiles.getEventIterator(this.pcesReplayLowerBound, this.startingRound);
        logger.info(LogMarker.STARTUP.getMarker(), "replaying preconsensus event stream starting at {}", (Object)this.pcesReplayLowerBound);
        this.platformCoordinator.injectPcesReplayerIterator(iterator);
        this.platformCoordinator.flushStateHasher();
        this.platformCoordinator.signalEndOfPcesReplay();
        this.platformCoordinator.submitStatusAction(new DoneReplayingEventsAction(this.platformContext.getTime().now()));
    }

    @Override
    @NonNull
    public PlatformContext getContext() {
        return this.platformContext;
    }

    @Override
    @NonNull
    public NotificationEngine getNotificationEngine() {
        return this.notificationEngine;
    }

    @Override
    @NonNull
    public Signature sign(@NonNull byte[] data) {
        return new PlatformSigner(this.keysAndCerts).sign(data);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        this.platformCoordinator.quiescenceCommand(quiescenceCommand);
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.currentRoster;
    }

    @Override
    @NonNull
    public <T extends State> AutoCloseableWrapper<T> getLatestImmutableState(@NonNull String reason) {
        ReservedSignedState wrapper = this.latestImmutableStateNexus.getState(reason);
        return wrapper == null ? AutoCloseableWrapper.empty() : new AutoCloseableWrapper((Object)wrapper.get().getState(), wrapper::close);
    }
}

