/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api.codec;

import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hiero.block.api.StateProof;

public final class StateProofJsonCodec
implements JsonCodec<StateProof> {
    @NonNull
    public StateProof parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_block_number = 0L;
            Bytes temp_value = Bytes.EMPTY;
            List temp_sibling_hashes = Collections.emptyList();
            Bytes temp_block_signature = Bytes.EMPTY;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "blockNumber": {
                        temp_block_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "value": {
                        temp_value = Bytes.fromBase64((String)JsonTools.checkSize((String)"value", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block14;
                    }
                    case "siblingHashes": {
                        temp_sibling_hashes = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"sibling_hashes", (List)kvPair.value().arr().value(), (int)maxSize), MerkleSiblingHash.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block14;
                    }
                    case "blockSignature": {
                        temp_block_signature = Bytes.fromBase64((String)JsonTools.checkSize((String)"block_signature", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new StateProof(temp_block_number, temp_value, temp_sibling_hashes, temp_block_signature);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull StateProof data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.blockNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"blockNumber", (long)data.blockNumber()));
        }
        if (data.value() != Bytes.EMPTY && data.value() != null && data.value().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"value", (Bytes)data.value()));
        }
        if (!data.siblingHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"siblingHashes", MerkleSiblingHash.JSON, data.siblingHashes()));
        }
        if (data.blockSignature() != Bytes.EMPTY && data.blockSignature() != null && data.blockSignature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"blockSignature", (Bytes)data.blockSignature()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

