/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.BlockProof;
import com.hedera.hapi.block.stream.ChainOfTrustProof;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.hapi.block.stream.SignedRecordFileProof;
import com.hedera.hapi.block.stream.StateProof;
import com.hedera.hapi.block.stream.TssSignedBlockProof;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BlockProofJsonCodec
implements JsonCodec<BlockProof> {
    public static final OneOf<BlockProof.ProofOneOfType> PROOF_UNSET = new OneOf((Enum)BlockProof.ProofOneOfType.UNSET, null);

    @NonNull
    public BlockProof parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_block = 0L;
            Bytes temp_previous_block_root_hash = Bytes.EMPTY;
            Bytes temp_start_of_block_state_root_hash = Bytes.EMPTY;
            Bytes temp_block_signature = Bytes.EMPTY;
            List temp_sibling_hashes = Collections.emptyList();
            Bytes temp_verification_key = Bytes.EMPTY;
            ChainOfTrustProof temp_verification_key_proof = null;
            OneOf temp_proof = PROOF_UNSET;
            block26: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "block": {
                        temp_block = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block26;
                    }
                    case "previousBlockRootHash": {
                        temp_previous_block_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"previous_block_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block26;
                    }
                    case "startOfBlockStateRootHash": {
                        temp_start_of_block_state_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"start_of_block_state_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block26;
                    }
                    case "blockSignature": {
                        temp_block_signature = Bytes.fromBase64((String)JsonTools.checkSize((String)"block_signature", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block26;
                    }
                    case "siblingHashes": {
                        temp_sibling_hashes = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"sibling_hashes", (List)kvPair.value().arr().value(), (int)maxSize), MerkleSiblingHash.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block26;
                    }
                    case "verificationKey": {
                        temp_verification_key = Bytes.fromBase64((String)JsonTools.checkSize((String)"verification_key", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block26;
                    }
                    case "verificationKeyProof": {
                        temp_verification_key_proof = (ChainOfTrustProof)ChainOfTrustProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block26;
                    }
                    case "signedBlockProof": {
                        temp_proof = new OneOf((Enum)BlockProof.ProofOneOfType.SIGNED_BLOCK_PROOF, TssSignedBlockProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block26;
                    }
                    case "blockStateProof": {
                        temp_proof = new OneOf((Enum)BlockProof.ProofOneOfType.BLOCK_STATE_PROOF, StateProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block26;
                    }
                    case "signedRecordFileProof": {
                        temp_proof = new OneOf((Enum)BlockProof.ProofOneOfType.SIGNED_RECORD_FILE_PROOF, SignedRecordFileProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block26;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockProof(temp_block, temp_previous_block_root_hash, temp_start_of_block_state_root_hash, temp_block_signature, temp_sibling_hashes, temp_verification_key, temp_verification_key_proof, temp_proof);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockProof data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.block() != 0L) {
            fieldLines.add(JsonTools.field((String)"block", (long)data.block()));
        }
        if (data.previousBlockRootHash() != Bytes.EMPTY && data.previousBlockRootHash() != null && data.previousBlockRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"previousBlockRootHash", (Bytes)data.previousBlockRootHash()));
        }
        if (data.startOfBlockStateRootHash() != Bytes.EMPTY && data.startOfBlockStateRootHash() != null && data.startOfBlockStateRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"startOfBlockStateRootHash", (Bytes)data.startOfBlockStateRootHash()));
        }
        if (data.blockSignature() != Bytes.EMPTY && data.blockSignature() != null && data.blockSignature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"blockSignature", (Bytes)data.blockSignature()));
        }
        if (!data.siblingHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"siblingHashes", MerkleSiblingHash.JSON, data.siblingHashes()));
        }
        if (data.verificationKey() != Bytes.EMPTY && data.verificationKey() != null && data.verificationKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"verificationKey", (Bytes)data.verificationKey()));
        }
        if (data.verificationKeyProof() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"verificationKeyProof", ChainOfTrustProof.JSON, (Object)data.verificationKeyProof()));
        }
        if (data.proof().kind() == BlockProof.ProofOneOfType.SIGNED_BLOCK_PROOF) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"signedBlockProof", TssSignedBlockProof.JSON, (Object)data.signedBlockProof()));
        }
        if (data.proof().kind() == BlockProof.ProofOneOfType.BLOCK_STATE_PROOF) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockStateProof", StateProof.JSON, (Object)data.blockStateProof()));
        }
        if (data.proof().kind() == BlockProof.ProofOneOfType.SIGNED_RECORD_FILE_PROOF) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"signedRecordFileProof", SignedRecordFileProof.JSON, (Object)data.signedRecordFileProof()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

