/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.google.protobuf.ByteString;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.FastCopyable;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.FCMSequential;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.HotspotConfiguration;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.PttTransactionPool;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.fs.stresstest.proto.Activity;
import com.swirlds.demo.platform.fs.stresstest.proto.AssortedAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.AssortedFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.BurnToken;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccountFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteFCQNode;
import com.swirlds.demo.platform.fs.stresstest.proto.DummyTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTxType;
import com.swirlds.demo.platform.fs.stresstest.proto.FCQTxType;
import com.swirlds.demo.platform.fs.stresstest.proto.MintToken;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalance;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalanceFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferToken;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccountFCQ;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.platform.system.Platform;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public class FCMTransactionPool
implements FastCopyable {
    private static final long VERSION = 1L;
    private static final Logger logger = LogManager.getLogger(FCMTransactionPool.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    public static final Marker DEMO_TRANSACTION_INFO = MarkerManager.getMarker((String)"DEMO_TRANSACTION_INFO");
    private Random random;
    private FCMConfig config;
    private PayloadConfig payloadConfig;
    private long myID;
    private Platform platform;
    private TransactionPoolNexus transactionPool;
    private TransactionSubmitter submitter;
    private int sequentialTypeIndex = 0;
    private long[] sequentialTestCount = null;
    private boolean doneWithGeneration = false;
    private PttTransactionPool parentPool;
    private final ExpectedFCMFamily expectedFCMFamily;
    private int loopCounter = 0;
    private Long assortedFCMEntityCount = 0L;
    private Long assortedFCQEntityCount = 0L;
    private PAYLOAD_TYPE generateType;
    private FCMSequential currentSequential;
    private int sizeAfterPadding;
    private Pair<FCMTransaction.Builder, MapKey> pair;
    private boolean immutable;
    private int accountSubsetFCM = 0;
    private int accountSubsetFCMFCQ = 0;
    private int tokenIdIndex = 0;
    public static final int UNRESTRICTED_SUBSET = 0;
    private static final int STEP = 3;
    private static final int TRANSFER_AMOUNT = 1000;
    private static final int INIT_BALANCE = 100000;
    private static final int INIT_THRESHOLD = 10000;

    private int getAccountSubsetFCM() {
        return this.accountSubsetFCM;
    }

    private void setAccountSubsetFCM(int accountSubsetFCM) {
        this.accountSubsetFCM = accountSubsetFCM;
    }

    private int getAccountSubsetFCMFCQ() {
        return this.accountSubsetFCMFCQ;
    }

    private void setAccountSubsetFCMFCQ(int accountSubsetFCMFCQ) {
        this.accountSubsetFCMFCQ = accountSubsetFCMFCQ;
    }

    public FCMTransactionPool(Platform platform, TransactionPoolNexus transactionPool, long myID, FCMConfig config, TransactionSubmitter submitter, PttTransactionPool parentPool, ExpectedFCMFamily expectedFCMFamily, PayloadConfig payloadConfig) {
        this.expectedFCMFamily = expectedFCMFamily;
        if (config == null) {
            return;
        }
        this.random = new Random();
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        logger.info(MARKER, "Random seed for FCMTransactionPool is {}", new Supplier[]{() -> seed});
        this.myID = myID;
        this.config = config;
        this.platform = platform;
        this.submitter = submitter;
        this.parentPool = parentPool;
        logger.info(DEMO_TRANSACTION_INFO, "Running on platform with id {}", new Supplier[]{() -> this.myID});
        if (config.isSequentialTest()) {
            this.sequentialTestCount = new long[config.getSequentials().length];
            logger.info(MARKER, "This test will generate sequential FCM payload:");
            for (int i = 0; i < config.getSequentials().length; ++i) {
                logger.info(DEMO_TRANSACTION_INFO, "This test will generate FCM payload type {} for {} times", (Object)config.getSequentialType(i), (Object)config.getSequentialAmount(i));
            }
        }
        this.payloadConfig = payloadConfig;
    }

    public Triple<byte[], PAYLOAD_TYPE, MapKey> getTransaction(boolean invalidSig) {
        Pair<FCMTransaction, MapKey> transactionMapKeyPair = null;
        transactionMapKeyPair = this.getPayloadFromSequentialTest(invalidSig);
        if (transactionMapKeyPair == null) {
            return null;
        }
        PAYLOAD_TYPE payloadType = PAYLOAD_TYPE.BodyCase_TO_PAYLOAD_TYPE.get((Object)((FCMTransaction)transactionMapKeyPair.key()).getBodyCase());
        Triple<byte[], PAYLOAD_TYPE, MapKey> rval = Triple.of(TestTransaction.newBuilder().setFcmTransaction((FCMTransaction)transactionMapKeyPair.key()).build().toByteArray(), payloadType, (MapKey)transactionMapKeyPair.value());
        return rval;
    }

    private boolean isSkipStage() {
        ArrayList<Long> nodeList;
        if (this.config.getNodeList() != null && (nodeList = this.config.getNodeList()[this.sequentialTypeIndex]).size() != 0 && !nodeList.contains(this.myID)) {
            PAYLOAD_TYPE skipType = this.config.getSequentialType(this.sequentialTypeIndex);
            logger.info(MARKER, "Skip transaction generation for node <{}> for type {}", (Object)this.myID, (Object)skipType);
            return true;
        }
        return false;
    }

    private void setCustomizeTPS() {
        if (this.sequentialTestCount[this.sequentialTypeIndex] == 0L) {
            if (this.config.getTpsList() != null) {
                ArrayList<Long> tpsList = this.config.getTpsList()[this.sequentialTypeIndex];
                for (int i = 0; i < tpsList.size(); ++i) {
                    if (this.myID != (long)i) continue;
                    this.submitter.setCustomizedTPS(tpsList.get(i));
                    return;
                }
            }
            this.submitter.setCustomizedTPS(0L);
        }
    }

    private void getPayloadTypeAndSize() {
        this.setCustomizeTPS();
        this.generateType = this.config.getSequentialType(this.sequentialTypeIndex);
        this.currentSequential = this.sequentialTypeIndex < this.config.getSequentials().length ? this.config.getSequentials()[this.sequentialTypeIndex] : null;
        this.sizeAfterPadding = this.config.getSequentialSize(this.sequentialTypeIndex);
        int n = this.sequentialTypeIndex;
        this.sequentialTestCount[n] = this.sequentialTestCount[n] + 1L;
    }

    private Pair<FCMTransaction, MapKey> getPayloadFromSequentialTest(boolean invalidSig) {
        this.skipSequentialAmountZero();
        while (this.sequentialTypeIndex < this.config.getSequentials().length && this.isSkipStage()) {
            ++this.sequentialTypeIndex;
        }
        if (this.doneWithGeneration) {
            return null;
        }
        if (this.sequentialTypeIndex >= this.config.getSequentials().length) {
            logger.info(MARKER, "Generated enough FCM test for sequential mode, stop generating {} >= {}", new Supplier[]{() -> this.sequentialTypeIndex, () -> this.config.getSequentials().length});
            this.doneWithGeneration = true;
            return null;
        }
        this.getPayloadTypeAndSize();
        while (this.generateType == PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET || this.generateType == PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET_FCQ) {
            if (this.generateType == PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET) {
                this.setAccountSubsetFCM(this.config.getSequentialAmount(this.sequentialTypeIndex));
            }
            if (this.generateType == PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET_FCQ) {
                this.setAccountSubsetFCMFCQ(this.config.getSequentialAmount(this.sequentialTypeIndex));
            }
            ++this.sequentialTypeIndex;
            this.getPayloadTypeAndSize();
        }
        if (this.generateType == PAYLOAD_TYPE.TYPE_TEST_SYNC) {
            ++this.sequentialTypeIndex;
            this.skipInvalidStageAfterPause();
            int interval = this.sizeAfterPadding;
            this.submitter.sendTransaction(this.transactionPool, this.parentPool.createControlTranBytes(ControlType.ENTER_SYNC));
            while (this.sequentialTypeIndex < this.config.getSequentials().length && this.isSkipStage()) {
                ++this.sequentialTypeIndex;
            }
            if (this.sequentialTypeIndex >= this.config.getSequentials().length) {
                logger.info(MARKER, "Generated enough FCM test for sequential mode");
                return null;
            }
            this.getPayloadTypeAndSize();
        }
        if (this.generateType == PAYLOAD_TYPE.TYPE_TEST_LOOP && this.loopCounter < this.config.getSequentialAmount(this.sequentialTypeIndex)) {
            this.sequentialTypeIndex = 0;
            this.sequentialTestCount = new long[this.config.getSequentials().length];
            ++this.loopCounter;
            this.getPayloadTypeAndSize();
            logger.info(MARKER, "TYPE_TEST_LOOP detected loop counter {}", (Object)this.loopCounter);
        }
        if (this.sequentialTestCount[this.sequentialTypeIndex] >= (long)this.config.getSequentialAmount(this.sequentialTypeIndex)) {
            logger.info(MARKER, "Generated enough FCM transaction for type {}", (Object)this.generateType);
            ++this.sequentialTypeIndex;
        }
        return this.getPayloadFromType(this.sizeAfterPadding, this.generateType, invalidSig);
    }

    private Pair<FCMTransaction, MapKey> getPayloadFromType(int sizeAfterPadding, PAYLOAD_TYPE generateType, boolean invalidSig) {
        Pair<FCMTransaction.Builder, MapKey> builderMapKeyPair;
        this.checkAccountCounter(generateType);
        switch (generateType) {
            case TYPE_FCM_CREATE: {
                builderMapKeyPair = this.generateFCMCreateAccountWithID(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_TRANSFER: {
                builderMapKeyPair = this.generateFCMTransferBalanceWithAccountFrom(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_UPDATE: {
                builderMapKeyPair = this.generateFCMUpdateAccountWithAccountID(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_DELETE: {
                builderMapKeyPair = this.generateFCMDeleteAccountWithID(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_ASSORTED: {
                builderMapKeyPair = this.generateFCMAssorted(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_ASSORTED_FCQ: {
                builderMapKeyPair = this.generateFCMAssortedFCQ(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_CREATE_FCQ: {
                builderMapKeyPair = this.generateFCMCreateAccountFCQWithId(sizeAfterPadding, false);
                break;
            }
            case TYPE_FCM_CREATE_WITH_RECORDS_FCQ: {
                builderMapKeyPair = this.generateFCMCreateAccountFCQWithId(sizeAfterPadding, true);
                break;
            }
            case TYPE_FCM_TRANSFER_FCQ: {
                builderMapKeyPair = this.generateFCMTransferFCQWithID(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_UPDATE_FCQ: {
                builderMapKeyPair = this.generateFCMUpdateFCQ(sizeAfterPadding);
                break;
            }
            case TYPE_FCM_DELETE_FCQ_NODE: {
                builderMapKeyPair = this.generateFCMDeleteFCQNode();
                break;
            }
            case TYPE_FCM_DELETE_FCQ: {
                builderMapKeyPair = this.generateFCMDeleteFCQ();
                break;
            }
            case TYPE_MINT_TOKEN: {
                builderMapKeyPair = this.generateMintToken();
                break;
            }
            case TYPE_TRANSFER_TOKEN: {
                builderMapKeyPair = this.generateTransferToken();
                break;
            }
            case TYPE_BURN_TOKEN: {
                builderMapKeyPair = this.generateBurnToken();
                break;
            }
            case TYPE_DUMMY_TRANSACTION: {
                builderMapKeyPair = this.generateDummyTransaction();
                break;
            }
            case SAVE_EXPECTED_MAP: {
                builderMapKeyPair = this.generateActivity(Activity.ActivityType.SAVE_EXPECTED_MAP);
                logger.info(MARKER, "node{} submits a transaction SAVE_EXPECTED_MAP", (Object)this.myID);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Invalid FCM operation: %s", new Object[]{generateType}));
            }
        }
        if (builderMapKeyPair == null) {
            return null;
        }
        FCMTransaction fcmTransaction = ((FCMTransaction.Builder)builderMapKeyPair.key()).setInvalidSig(invalidSig).setOriginNode(this.myID).build();
        return Pair.of((Object)fcmTransaction, (Object)((MapKey)builderMapKeyPair.value()));
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMDeleteFCQ() {
        MapKey key = this.getMapKeyForTx(TransactionType.Delete, EntityType.FCQ);
        if (key == null) {
            return null;
        }
        DeleteFCQ deleteFCQ = DeleteFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Deleting FCQ with key {}", new Supplier[]{() -> key});
        return Pair.of((Object)FCMTransaction.newBuilder().setDeleteFCQ(deleteFCQ), (Object)key);
    }

    private MapKey getMapKeyForTx(TransactionType txType, EntityType entityType) {
        if (txType.equals((Object)TransactionType.Create)) {
            return new MapKey(this.myID, this.myID, this.expectedFCMFamily.getNextIdToCreate());
        }
        if (entityType.equals((Object)EntityType.Crypto)) {
            if (txType.equals((Object)TransactionType.Transfer) || txType.equals((Object)TransactionType.Update)) {
                return this.expectedFCMFamily.getMapKeyForFCMTx(txType, entityType, this.payloadConfig.isPerformOnDeleted(), this.payloadConfig.isOperateEntitiesOfSameNode(), this.getAccountSubsetFCM());
            }
        } else if (entityType.equals((Object)EntityType.FCQ) && (txType.equals((Object)TransactionType.Transfer) || txType.equals((Object)TransactionType.Update))) {
            return this.expectedFCMFamily.getMapKeyForFCMTx(txType, entityType, this.payloadConfig.isPerformOnDeleted(), this.payloadConfig.isOperateEntitiesOfSameNode(), this.getAccountSubsetFCMFCQ());
        }
        return this.expectedFCMFamily.getMapKeyForFCMTx(txType, entityType, this.payloadConfig.isPerformOnDeleted(), this.payloadConfig.isOperateEntitiesOfSameNode(), 0);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateActivity(Activity.ActivityType type) {
        return Pair.of((Object)FCMTransaction.newBuilder().setActivity(Activity.newBuilder().setType(type)), null);
    }

    private void checkAccountCounter(PAYLOAD_TYPE type) {
        if (!type.name().startsWith("TYPE_FCM") || type.name().startsWith("TYPE_FCM_CREATE") || type.name().startsWith("TYPE_FCM_ASSORTED") || type.name().equals("TYPE_FCM_DELETE")) {
            return;
        }
        EntityType entityType = type.name().endsWith("FCQ") ? EntityType.FCQ : EntityType.Crypto;
        this.expectedFCMFamily.waitWhileExpectedMapEmpty(entityType, type);
    }

    private void skipSequentialAmountZero() {
        PAYLOAD_TYPE sequentialType;
        while (this.sequentialTypeIndex < this.config.getSequentials().length && this.config.getSequentialAmount(this.sequentialTypeIndex) == 0 && (sequentialType = this.config.getSequentials()[this.sequentialTypeIndex].getSequentialType()) != PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET && sequentialType != PAYLOAD_TYPE.TYPE_FCM_ACCOUNT_SUBSET_FCQ) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Warning: sequentialAmount is 0 for {}, will be skipped ", (Object)this.config.getSequentials()[this.sequentialTypeIndex]);
            ++this.sequentialTypeIndex;
        }
    }

    private void skipInvalidStageAfterPause() {
        PAYLOAD_TYPE test_type = this.config.getSequentialType(this.sequentialTypeIndex);
        long amount = this.config.getSequentialAmount(this.sequentialTypeIndex);
        while (this.sequentialTypeIndex < this.config.getSequentials().length && (amount == 0L || test_type == PAYLOAD_TYPE.TYPE_TEST_SYNC)) {
            if (test_type == PAYLOAD_TYPE.TYPE_TEST_SYNC) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Warning: A pause stage after previous pause stage, will be skipped ");
            } else {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Warning: sequentialAmount is 0 for {}, will be skipped ", (Object)test_type);
            }
            ++this.sequentialTypeIndex;
            test_type = this.config.getSequentialType(this.sequentialTypeIndex);
            amount = this.config.getSequentialAmount(this.sequentialTypeIndex);
        }
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMUpdateFCQ(int contentSize) {
        MapKey key = this.getMapKeyForTx(TransactionType.Update, EntityType.FCQ);
        if (key == null) {
            return null;
        }
        byte[] content = new byte[contentSize];
        this.random.nextBytes(content);
        UpdateAccountFCQ updateAccountFCQ = UpdateAccountFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(this.random.nextInt(1000)).setIndex(1L).setContent(ByteString.copyFrom((byte[])content)).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Updating FCQ with key {}", new Supplier[]{() -> key});
        this.modifyExpectedValue(key, TransactionType.Update);
        return Pair.of((Object)FCMTransaction.newBuilder().setUpdateAccountFCQ(updateAccountFCQ), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMDeleteFCQNode() {
        MapKey key = this.getMapKeyForTx(TransactionType.Update, EntityType.FCQ);
        if (key == null) {
            return null;
        }
        DeleteFCQNode delete = DeleteFCQNode.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setIndex(0L).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Deleting node from FCQ with key {}", new Supplier[]{() -> key});
        this.modifyExpectedValue(key, TransactionType.Update);
        return Pair.of((Object)FCMTransaction.newBuilder().setDeleteFCQNode(delete), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMCreateAccountFCQWithId(int contentSize, boolean withRecords) {
        MapKey key = this.getMapKeyForTx(TransactionType.Create, EntityType.FCQ);
        if (key == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate MapKey for CreateFCQ transaction");
            return null;
        }
        byte[] content = new byte[contentSize];
        this.random.nextBytes(content);
        long initialRecordNum = withRecords ? (long)this.config.getInitialRecordNum() : 1L;
        CreateAccountFCQ createAccountFCQ = CreateAccountFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(100000L + key.getAccountId()).setIndex(0L).setContent(ByteString.copyFrom((byte[])content)).setInitialRecordNum(initialRecordNum).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Creating FCQ with key {}, initialRecordNum: {}", new Supplier[]{() -> key, () -> initialRecordNum});
        this.addEntitiesToExpectedMap(key.getAccountId(), EntityType.FCQ);
        return Pair.of((Object)FCMTransaction.newBuilder().setCreateAccountFCQ(createAccountFCQ), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMTransferFCQWithID(int contentSize) {
        MapKey fromKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
        MapKey toKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
        while (fromKey != null && fromKey.equals((Object)toKey)) {
            toKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
        }
        if (fromKey == null || toKey == null) {
            return null;
        }
        byte[] fromContent = new byte[contentSize];
        byte[] toContent = new byte[contentSize];
        this.random.nextBytes(fromContent);
        this.random.nextBytes(toContent);
        TransferBalanceFCQ transfer = TransferBalanceFCQ.newBuilder().setFromShardID(fromKey.getShardId()).setFromRealmID(fromKey.getRealmId()).setFromAccountID(fromKey.getAccountId()).setToShardID(toKey.getShardId()).setToRealmID(toKey.getRealmId()).setToAccountID(toKey.getAccountId()).setTransferAmount(1000L).setNewFromContent(ByteString.copyFrom((byte[])fromContent)).setNewToContent(ByteString.copyFrom((byte[])toContent)).build();
        MapKey toKeyFinal = toKey;
        logger.trace(DEMO_TRANSACTION_INFO, "Transferring FCQ with key {} and {}", new Supplier[]{() -> fromKey, () -> toKeyFinal});
        this.modifyExpectedValue(fromKey, TransactionType.Transfer);
        return Pair.of((Object)FCMTransaction.newBuilder().setTransferBalanceFCQ(transfer), (Object)fromKey);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateTransferToken() {
        MapKey key = this.getMapKeyForTx(TransactionType.Update, EntityType.Crypto);
        if (key == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate MapKey for transaction transferToken");
            return null;
        }
        Optional<NftId> nftIdCheck = this.expectedFCMFamily.getAnyNftId();
        if (nftIdCheck.isEmpty()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate TokenId for transaction TransferToken");
            return null;
        }
        NftId nftId = nftIdCheck.get();
        TransferToken transferToken = TransferToken.newBuilder().setTokenRealmId(nftId.getRealmNum()).setTokenShardId(nftId.getShardNum()).setTokenId(nftId.getTokenNum()).setToRealmId(key.getRealmId()).setToShardId(key.getShardId()).setToAccountId(key.getAccountId()).build();
        return Pair.of((Object)FCMTransaction.newBuilder().setTransferToken(transferToken), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateDummyTransaction() {
        DummyTransaction dummyTransaction = DummyTransaction.newBuilder().build();
        return Pair.of((Object)FCMTransaction.newBuilder().setDummyTransaction(dummyTransaction), null);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateBurnToken() {
        Optional<NftId> nftIdCheck = this.expectedFCMFamily.getAnyNftId();
        if (nftIdCheck.isEmpty()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate TokenId for transaction BurnToken");
            return null;
        }
        NftId nftId = nftIdCheck.get();
        BurnToken burnToken = BurnToken.newBuilder().setTokenRealmId(nftId.getRealmNum()).setTokenShardId(nftId.getShardNum()).setTokenId(nftId.getTokenNum()).build();
        return Pair.of((Object)FCMTransaction.newBuilder().setBurnToken(burnToken), null);
    }

    private MapKey getNewTokenOwner() {
        double choice;
        if (this.currentSequential == null) {
            throw new IllegalStateException("The mint token operation must have a non-null sequential");
        }
        HotspotConfiguration hotspotConfiguration = this.currentSequential.getHotspot();
        if (hotspotConfiguration != null && (choice = this.random.nextDouble()) < hotspotConfiguration.getFrequency()) {
            MapKey key = this.expectedFCMFamily.getMapKeyForFCMTx(TransactionType.MintToken, EntityType.Crypto, false, false, hotspotConfiguration.getSize());
            return key;
        }
        return this.getMapKeyForTx(TransactionType.MintToken, EntityType.Crypto);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateMintToken() {
        MapKey key = this.getNewTokenOwner();
        if (key == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate MapKey for MintToken transaction");
            return null;
        }
        byte[] serialNumber = new byte[10];
        byte[] memo = new byte[10];
        byte[] symbol = new byte[10];
        this.random.nextBytes(serialNumber);
        this.random.nextBytes(memo);
        this.random.nextBytes(symbol);
        MintToken mintToken = MintToken.newBuilder().setAccountId(key.getAccountId()).setShardId(key.getShardId()).setRealmId(key.getRealmId()).setTokenRealmId(this.myID).setTokenShardId(this.myID).setTokenId(this.tokenIdIndex++).setSerialNumber(new String(serialNumber)).setMemo(new String(memo)).build();
        return Pair.of((Object)FCMTransaction.newBuilder().setMintToken(mintToken), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMCreateAccountWithID(int sizeAfterPading) {
        MapKey key = this.getMapKeyForTx(TransactionType.Create, EntityType.Crypto);
        if (key == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to generate MapKey for CreateAccount transaction");
            return null;
        }
        CreateAccount createAccount = CreateAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(100000L + key.getAccountId()).setSendThreshold(10000L + key.getAccountId()).setReceiveThreshold(10000L + key.getAccountId()).setRequireSignature(false).setUid(this.random.nextLong()).build();
        this.addEntitiesToExpectedMap(key.getAccountId(), EntityType.Crypto);
        logger.trace(DEMO_TRANSACTION_INFO, "Creating account with key {}", new Supplier[]{() -> key});
        int currentLen = createAccount.toByteArray().length;
        if (currentLen < sizeAfterPading) {
            byte[] paddingBytes = new byte[sizeAfterPading - currentLen];
            return Pair.of((Object)FCMTransaction.newBuilder().setCreateAccount(createAccount).setPaddingBytes(ByteString.copyFrom((byte[])paddingBytes)), (Object)key);
        }
        return Pair.of((Object)FCMTransaction.newBuilder().setCreateAccount(createAccount), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMTransferBalanceWithAccountFrom(int sizeAfterPading) {
        MapKey fromKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
        MapKey toKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
        while (fromKey != null && fromKey.equals((Object)toKey)) {
            toKey = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
        }
        if (fromKey == null || toKey == null) {
            return null;
        }
        TransferBalance transferBalance = TransferBalance.newBuilder().setFromShardID(fromKey.getShardId()).setFromRealmID(fromKey.getRealmId()).setFromAccountID(fromKey.getAccountId()).setToShardID(toKey.getShardId()).setToRealmID(toKey.getRealmId()).setToAccountID(toKey.getAccountId()).setTransferAmount(1000L).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Transferring CryptoAccount with key ({},{},{}) and ({},{},{})", (Object)this.myID, (Object)this.myID, (Object)fromKey.getAccountId(), (Object)this.myID, (Object)this.myID, (Object)toKey.getAccountId());
        this.modifyExpectedValue(fromKey, TransactionType.Transfer);
        this.modifyExpectedValue(toKey, TransactionType.Transfer);
        int currentLen = transferBalance.toByteArray().length;
        if (currentLen < sizeAfterPading) {
            byte[] paddingBytes = new byte[sizeAfterPading - currentLen];
            return Pair.of((Object)FCMTransaction.newBuilder().setTransferBalance(transferBalance).setPaddingBytes(ByteString.copyFrom((byte[])paddingBytes)), (Object)fromKey);
        }
        return Pair.of((Object)FCMTransaction.newBuilder().setTransferBalance(transferBalance), (Object)fromKey);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMUpdateAccountWithAccountID(int sizeAfterPading) {
        MapKey key = this.getMapKeyForTx(TransactionType.Update, EntityType.Crypto);
        if (key == null) {
            return null;
        }
        UpdateAccount updateAccount = UpdateAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance((100000L + key.getAccountId()) * 2L).setSendThreshold((10000L + key.getAccountId()) * 2L).setReceiveThreshold((10000L + key.getAccountId()) * 2L).setRequireSignature(false).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Updating account with key ({},{},{})", new Supplier[]{() -> this.myID, () -> this.myID, () -> key.getAccountId()});
        this.modifyExpectedValue(key, TransactionType.Update);
        int currentLen = updateAccount.toByteArray().length;
        if (currentLen < sizeAfterPading) {
            byte[] paddingBytes = new byte[sizeAfterPading - currentLen];
            return Pair.of((Object)FCMTransaction.newBuilder().setUpdateAccount(updateAccount).setPaddingBytes(ByteString.copyFrom((byte[])paddingBytes)), (Object)key);
        }
        return Pair.of((Object)FCMTransaction.newBuilder().setUpdateAccount(updateAccount), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMDeleteAccountWithID(int sizeAfterPading) {
        MapKey key = this.getMapKeyForTx(TransactionType.Delete, EntityType.Crypto);
        if (key == null) {
            return null;
        }
        DeleteAccount deleteAccount = DeleteAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
        logger.trace(DEMO_TRANSACTION_INFO, "Deleting account with key {}", new Supplier[]{() -> key});
        this.modifyExpectedValue(key, TransactionType.Delete);
        int currentLen = deleteAccount.toByteArray().length;
        if (currentLen < sizeAfterPading) {
            byte[] paddingBytes = new byte[sizeAfterPading - currentLen];
            return Pair.of((Object)FCMTransaction.newBuilder().setDeleteAccount(deleteAccount).setPaddingBytes(ByteString.copyFrom((byte[])paddingBytes)), (Object)key);
        }
        return Pair.of((Object)FCMTransaction.newBuilder().setDeleteAccount(deleteAccount), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMAssorted(int sizeAfterPadding) {
        Long l;
        AssortedAccount assortedAccount = null;
        MapKey key = null;
        if (this.assortedFCMEntityCount > 2L) {
            switch (Objects.requireNonNull(FCMTxType.forNumber(this.random.nextInt(4)))) {
                case Update: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_UPDATE);
                    key = this.getMapKeyForTx(TransactionType.Update, EntityType.Crypto);
                    if (key == null) break;
                    assortedAccount = AssortedAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setAmountBalance((100000L + key.getAccountId()) * 2L).setSendThreshold((10000L + key.getAccountId()) * 2L).setReceiveThreshold((10000L + key.getAccountId()) * 2L).setRequireSignature(false).setTxType(FCMTxType.Update).build();
                    this.modifyExpectedValue(key, TransactionType.Update);
                    break;
                }
                case Transfer: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_TRANSFER);
                    key = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
                    MapKey keyTo = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
                    if (key == null) break;
                    while (key != null && key.equals((Object)keyTo)) {
                        keyTo = this.getMapKeyForTx(TransactionType.Transfer, EntityType.Crypto);
                    }
                    if (keyTo != null) {
                        assortedAccount = AssortedAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setShardIdTo(keyTo.getShardId()).setRealmIdTo(keyTo.getRealmId()).setAccountIdTo(keyTo.getAccountId()).setAmountBalance(1000L).setTxType(FCMTxType.Transfer).build();
                        this.modifyExpectedValue(key, TransactionType.Transfer);
                        this.modifyExpectedValue(keyTo, TransactionType.Transfer);
                        break;
                    }
                    key = null;
                    break;
                }
                case Delete: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_DELETE);
                    key = this.getMapKeyForTx(TransactionType.Delete, EntityType.Crypto);
                    if (key == null) break;
                    assortedAccount = AssortedAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setTxType(FCMTxType.Delete).build();
                    this.modifyExpectedValue(key, TransactionType.Delete);
                    l = this.assortedFCMEntityCount;
                    this.assortedFCMEntityCount = this.assortedFCMEntityCount - 1L;
                    break;
                }
            }
        }
        if (key == null) {
            key = this.getMapKeyForTx(TransactionType.Create, EntityType.Crypto);
            assortedAccount = AssortedAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setAmountBalance(100000L + key.getAccountId()).setSendThreshold(10000L + key.getAccountId()).setReceiveThreshold(10000L + key.getAccountId()).setTxType(FCMTxType.Create).build();
            this.addEntitiesToExpectedMap(key.getAccountId(), EntityType.Crypto);
            l = this.assortedFCMEntityCount;
            this.assortedFCMEntityCount = this.assortedFCMEntityCount + 1L;
        }
        logger.info(DEMO_TRANSACTION_INFO, "assorted fcm transaction {} for key {}", (Object)assortedAccount.getTxType().name(), (Object)key);
        return Pair.of((Object)FCMTransaction.newBuilder().setAssortedAccount(assortedAccount), (Object)key);
    }

    private Pair<FCMTransaction.Builder, MapKey> generateFCMAssortedFCQ(int contentSize) {
        byte[] content;
        AssortedFCQ assortedFCQ = null;
        MapKey key = null;
        if (this.assortedFCQEntityCount > 2L) {
            switch (Objects.requireNonNull(FCQTxType.forNumber(this.random.nextInt(4)))) {
                case FCQUpdate: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_UPDATE_FCQ);
                    key = this.getMapKeyForTx(TransactionType.Update, EntityType.FCQ);
                    content = new byte[contentSize];
                    this.random.nextBytes(content);
                    if (key == null) break;
                    assortedFCQ = AssortedFCQ.newBuilder().setTxType(FCQTxType.FCQUpdate).setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setAmountBalance(this.random.nextInt(1000)).setIndex(1L).setContent(ByteString.copyFrom((byte[])content)).build();
                    this.modifyExpectedValue(key, TransactionType.Update);
                    break;
                }
                case FCQTransfer: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_TRANSFER_FCQ);
                    key = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
                    MapKey keyTo = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
                    if (key == null) break;
                    while (key != null && key.equals((Object)keyTo)) {
                        keyTo = this.getMapKeyForTx(TransactionType.Transfer, EntityType.FCQ);
                    }
                    if (keyTo != null) {
                        byte[] fromContent = new byte[contentSize];
                        byte[] toContent = new byte[contentSize];
                        this.random.nextBytes(fromContent);
                        this.random.nextBytes(toContent);
                        assortedFCQ = AssortedFCQ.newBuilder().setTxType(FCQTxType.FCQTransfer).setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setToShardID(keyTo.getShardId()).setToRealmID(keyTo.getRealmId()).setToAccountID(keyTo.getAccountId()).setAmountBalance(1000L).setContent(ByteString.copyFrom((byte[])fromContent)).setNewToContent(ByteString.copyFrom((byte[])toContent)).build();
                        this.modifyExpectedValue(key, TransactionType.Transfer);
                        break;
                    }
                    key = null;
                    break;
                }
                case FCQDelete: {
                    this.checkAccountCounter(PAYLOAD_TYPE.TYPE_FCM_DELETE_FCQ_NODE);
                    key = this.getMapKeyForTx(TransactionType.Delete, EntityType.FCQ);
                    if (key == null) break;
                    assortedFCQ = AssortedFCQ.newBuilder().setTxType(FCQTxType.FCQDelete).setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
                    this.modifyExpectedValue(key, TransactionType.Delete);
                    Long fromContent = this.assortedFCQEntityCount;
                    this.assortedFCQEntityCount = this.assortedFCQEntityCount - 1L;
                    break;
                }
            }
        }
        if (key == null) {
            key = this.getMapKeyForTx(TransactionType.Create, EntityType.FCQ);
            content = new byte[contentSize];
            this.random.nextBytes(content);
            boolean withRecords = false;
            long initialRecordNum = 1L;
            assortedFCQ = AssortedFCQ.newBuilder().setTxType(FCQTxType.FCQCreate).setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setAmountBalance(100000L + key.getAccountId()).setIndex(0L).setContent(ByteString.copyFrom((byte[])content)).setInitialRecordNum(initialRecordNum).build();
            this.addEntitiesToExpectedMap(key.getAccountId(), EntityType.FCQ);
            Long l = this.assortedFCQEntityCount;
            this.assortedFCQEntityCount = this.assortedFCQEntityCount + 1L;
        }
        logger.info(DEMO_TRANSACTION_INFO, "assorted FCQ transaction {} for key {}", (Object)assortedFCQ.getTxType().name(), (Object)key);
        return Pair.of((Object)FCMTransaction.newBuilder().setAssortedFCQ(assortedFCQ), (Object)key);
    }

    private void modifyExpectedValue(MapKey key, TransactionType transType) {
        ExpectedValue value = this.expectedFCMFamily.getExpectedMap().get(key);
        if (value != null) {
            value.setLatestSubmitStatus(new LifecycleStatus(TransactionState.INITIALIZED, transType, Instant.now().getEpochSecond(), this.myID));
            this.expectedFCMFamily.getExpectedMap().put(key, value);
        }
    }

    private void addEntitiesToExpectedMap(long accountID, EntityType entityType) {
        MapKey key = new MapKey(this.myID, this.myID, accountID);
        ExpectedValue value = new ExpectedValue(entityType, new LifecycleStatus(TransactionState.INITIALIZED, TransactionType.Create, Instant.now().getEpochSecond(), this.myID));
        this.expectedFCMFamily.addEntityToExpectedMap(key, value);
    }

    public FCMTransactionPool copy() {
        this.throwIfImmutable();
        return null;
    }

    public boolean isImmutable() {
        return this.immutable;
    }
}

