/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.util.Preconditions;

public abstract class AbstractAtomicFieldUpdaterAssert<SELF extends AbstractAtomicFieldUpdaterAssert<SELF, VALUE, ATOMIC, OBJECT>, VALUE, ATOMIC, OBJECT>
extends AbstractObjectAssert<SELF, ATOMIC> {
    private final boolean expectedNullAllowed;

    protected AbstractAtomicFieldUpdaterAssert(ATOMIC actual, Class<?> selfType, boolean expectedNullAllowed) {
        super(actual, selfType);
        this.expectedNullAllowed = expectedNullAllowed;
    }

    public SELF hasValue(VALUE expectedValue, OBJECT obj) {
        this.validate(expectedValue);
        VALUE actualValue = this.getActualValue(obj);
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, actualValue, expectedValue, obj));
        }
        return (SELF)((AbstractAtomicFieldUpdaterAssert)this.myself);
    }

    protected abstract VALUE getActualValue(OBJECT var1);

    protected void validate(VALUE expectedValue) {
        this.isNotNull();
        if (!this.expectedNullAllowed) {
            this.checkNotNull(expectedValue);
        }
    }

    private void checkNotNull(VALUE expectedValue) {
        Preconditions.checkArgument(expectedValue != null, "The expected value should not be <null>.", new Object[0]);
    }
}

