/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.test.fixtures.consensus.TestIntake;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.StandardEventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.stream.IntStream;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public final class GenerateConsensus {
    private GenerateConsensus() {
    }

    public static Deque<ConsensusRound> generateConsensusRounds(@NonNull PlatformContext platformContext, int numNodes, int numEvents, long seed) {
        Objects.requireNonNull(platformContext);
        ArrayList<EventSource> eventSources = new ArrayList<EventSource>();
        IntStream.range(0, numNodes).forEach(i -> eventSources.add(new StandardEventSource(false)));
        StandardGraphGenerator generator = new StandardGraphGenerator(platformContext, seed, eventSources);
        TestIntake intake = new TestIntake(platformContext, generator.getRoster());
        for (int i2 = 0; i2 < numEvents; ++i2) {
            intake.addEvent(generator.generateEvent().getBaseEvent());
        }
        return intake.getConsensusRounds();
    }
}

