/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.virtualmap.internal.merkle.ExternalVirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class VirtualMapMetadata {
    public static final int MAX_LABEL_CHARS = 512;
    private long firstLeafPath;
    private long lastLeafPath;
    private String label;

    public VirtualMapMetadata(@NonNull String label) {
        Objects.requireNonNull(label);
        this.firstLeafPath = -1L;
        this.lastLeafPath = -1L;
        this.label = label;
    }

    public VirtualMapMetadata(@NonNull String label, long stateSize) {
        Objects.requireNonNull(label);
        if (stateSize == 0L) {
            this.firstLeafPath = -1L;
            this.lastLeafPath = -1L;
        }
        if (stateSize == 1L) {
            this.firstLeafPath = 1L;
            this.lastLeafPath = 1L;
        } else {
            this.firstLeafPath = stateSize - 1L;
            this.lastLeafPath = this.firstLeafPath + stateSize - 1L;
        }
        this.label = label;
    }

    @Deprecated(forRemoval=true)
    public VirtualMapMetadata(@NonNull ExternalVirtualMapMetadata virtualMapMetadata) {
        Objects.requireNonNull(virtualMapMetadata);
        this.firstLeafPath = virtualMapMetadata.getFirstLeafPath();
        this.lastLeafPath = virtualMapMetadata.getLastLeafPath();
        this.label = virtualMapMetadata.getLabel();
    }

    private VirtualMapMetadata(VirtualMapMetadata virtualMapMetadata) {
        this.firstLeafPath = virtualMapMetadata.getFirstLeafPath();
        this.lastLeafPath = virtualMapMetadata.getLastLeafPath();
        this.label = virtualMapMetadata.getLabel();
    }

    public long getFirstLeafPath() {
        return this.firstLeafPath;
    }

    public void setFirstLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path > this.lastLeafPath) {
            throw new IllegalArgumentException("The firstLeafPath must be less than or equal to the lastLeafPath");
        }
        this.firstLeafPath = path;
    }

    public long getLastLeafPath() {
        return this.lastLeafPath;
    }

    public void setLastLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path < this.firstLeafPath && path != -1L) {
            throw new IllegalArgumentException("The lastLeafPath must be greater than or equal to the firstLeafPath");
        }
        this.lastLeafPath = path;
    }

    public long getSize() {
        if (this.firstLeafPath == -1L) {
            return 0L;
        }
        return this.lastLeafPath - this.firstLeafPath + 1L;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(@NonNull String label) {
        Objects.requireNonNull(label);
        if (label.length() > 512) {
            throw new IllegalArgumentException("Label cannot be greater than 512 characters");
        }
        this.label = label;
    }

    public VirtualMapMetadata copy() {
        return new VirtualMapMetadata(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("firstLeafPath", (Object)this.firstLeafPath).append("lastLeafPath", (Object)this.lastLeafPath).append("size", (Object)this.getSize()).append("label", (Object)this.label).toString();
    }
}

