/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;

public final class MerkleTreeSnapshotWriter {
    private static final Logger logger = LogManager.getLogger(MerkleTreeSnapshotWriter.class);

    private MerkleTreeSnapshotWriter() {
    }

    public static void createSnapshot(@NonNull MerkleNode merkleRoot, @NonNull Path targetPath, @NonNull String rootInfo) {
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Creating a snapshot on demand in {} for {}", (Object)targetPath, (Object)rootInfo);
        try {
            MerkleTreeSnapshotWriter.writeMerkleRootToFile(targetPath, merkleRoot);
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Successfully created a snapshot on demand in {}  for {}", (Object)targetPath, (Object)rootInfo);
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to write a snapshot on demand for {} to {}.", (Object)rootInfo, (Object)targetPath, (Object)e);
        }
    }

    private static void writeMerkleRootToFile(@NonNull Path directory, @NonNull MerkleNode merkleRoot) throws IOException {
        FileUtils.writeAndFlush(directory.resolve("SignedState.swh"), out -> MerkleTreeSnapshotWriter.writeMerkleRootToStream(out, directory, merkleRoot));
    }

    private static void writeMerkleRootToStream(@NonNull MerkleDataOutputStream out, @NonNull Path directory, @NonNull MerkleNode merkleRoot) throws IOException {
        out.write(127);
        out.writeInt(2);
        out.writeProtocolVersion();
        out.writeMerkleTree(directory, merkleRoot);
        out.writeSerializable((SelfSerializable)merkleRoot.getHash(), true);
    }
}

