/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal;

import com.swirlds.base.internal.BaseExecutorFactory;
import com.swirlds.base.utility.FileSystemUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.PropertyFileConfigSource;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Logger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.internal.LoggingSystem;
import com.swirlds.logging.api.internal.configuration.ConfigLevelConverter;
import com.swirlds.logging.api.internal.configuration.InternalLoggingConfig;
import com.swirlds.logging.api.internal.configuration.MarkerStateConverter;
import com.swirlds.logging.api.internal.emergency.EmergencyLoggerImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultLoggingSystem {
    private static final String ENV_PROPERTY_LOG_PATH = "LOG_CONFIG_PATH";
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final LoggingSystem internalLoggingSystem;

    private DefaultLoggingSystem() {
        try {
            Configuration configuration = DefaultLoggingSystem.createConfiguration();
            this.internalLoggingSystem = new LoggingSystem(configuration);
            this.internalLoggingSystem.installHandlers();
            this.internalLoggingSystem.installProviders();
            EmergencyLoggerImpl.getInstance().publishLoggedEvents().stream().map(event -> this.internalLoggingSystem.getLogEventFactory().createLogEvent(event.level(), "EMERGENCY-LOGGER-QUEUE", event.threadName(), event.timestamp(), event.message(), event.throwable(), event.marker(), event.context())).forEach(this.internalLoggingSystem::accept);
            this.initialized.set(true);
            InternalLoggingConfig loggingConfig = (InternalLoggingConfig)configuration.getConfigData(InternalLoggingConfig.class);
            long millis = Optional.ofNullable(loggingConfig.reloadConfigPeriod()).orElse(Duration.ofSeconds(10L)).toMillis();
            BaseExecutorFactory.getInstance().scheduleAtFixedRate(this::updateConfiguration, 0L, millis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Unable to initialize logging system", e);
            throw e;
        }
    }

    private void updateConfiguration() {
        Configuration configuration = DefaultLoggingSystem.createConfiguration();
        this.internalLoggingSystem.update(configuration);
    }

    @NonNull
    private static Configuration createConfiguration() {
        String logConfigPath = System.getenv(ENV_PROPERTY_LOG_PATH);
        Path configFilePath = Optional.ofNullable(logConfigPath).map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> Path.of("log.properties", new String[0]));
        try {
            if (!FileSystemUtils.waitForPathPresence((Path)configFilePath)) {
                throw new FileNotFoundException("File not found: " + String.valueOf(configFilePath));
            }
            PropertyFileConfigSource configSource = new PropertyFileConfigSource(configFilePath);
            return ConfigurationBuilder.create().withSource((ConfigSource)configSource).withConfigDataType(InternalLoggingConfig.class).withConverter((ConfigConverter)new MarkerStateConverter()).withConverter((ConfigConverter)new ConfigLevelConverter()).build();
        }
        catch (IOException e) {
            EMERGENCY_LOGGER.log(Level.WARN, "Unable to load logging configuration from path: '%s'. Using default configuration.".formatted(configFilePath));
            return ConfigurationBuilder.create().withConfigDataType(InternalLoggingConfig.class).build();
        }
    }

    @NonNull
    public static DefaultLoggingSystem getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @NonNull
    public Logger getLogger(@NonNull String loggerName) {
        return this.internalLoggingSystem.getLogger(loggerName);
    }

    public void addHandler(@NonNull LogHandler logHandler) {
        this.internalLoggingSystem.addHandler(logHandler);
    }

    public void removeHandler(@NonNull LogHandler logHandler) {
        this.internalLoggingSystem.removeHandler(logHandler);
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    private static final class InstanceHolder {
        private static final DefaultLoggingSystem INSTANCE = new DefaultLoggingSystem();

        private InstanceHolder() {
        }
    }
}

