/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui;

import com.swirlds.common.Console;
import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.internal.SwirldMenu;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public final class SwirldsGui {
    private static final Logger logger = LogManager.getLogger(SwirldsGui.class);

    private SwirldsGui() {
    }

    public static Console createConsole(@NonNull Platform platform, int winNum, boolean visible) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        NodeId selfId = platform.getSelfId();
        int winCount = platform.getRoster().rosterEntries().size();
        Rectangle winRect = GuiUtils.winRect(winCount, winNum);
        Console console = GuiUtils.createBasicConsole(RosterUtils.formatNodeName((long)selfId.id()), winRect, visible);
        SwirldMenu.addTo(platform, console.getWindow(), 40, Color.white, false);
        return console;
    }
}

