/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto.internal;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.PublicKey;
import org.hiero.base.crypto.BytesSignatureVerifier;
import org.hiero.consensus.crypto.internal.SodiumJni;

public class SodiumVerifier
implements BytesSignatureVerifier {
    private final byte[] publicKey;

    public SodiumVerifier(@NonNull PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        this.publicKey = new byte[32];
        System.arraycopy(encoded, encoded.length - 32, this.publicKey, 0, 32);
    }

    public boolean verify(@NonNull Bytes data, @NonNull Bytes signature) {
        return SodiumJni.SODIUM.cryptoSignVerifyDetached(signature.toByteArray(), data.toByteArray(), Math.toIntExact(data.length()), this.publicKey);
    }
}

