/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.stream;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.stream.ExportAccountObject;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.platform.system.Platform;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Signature;

public class AccountBalanceExport {
    static final byte TYPE_SIGNATURE = 3;
    static final byte TYPE_FILE_HASH = 4;
    private static final Logger logger = LogManager.getLogger(AccountBalanceExport.class);
    private static final String lineSperator = "line.separator";
    private final long exportPeriodSec;
    private Instant previousTimestamp = null;

    public AccountBalanceExport(long exportPeriodSec) {
        this.exportPeriodSec = exportPeriodSec;
    }

    public boolean timeToExport(Instant consensusTimestamp) {
        if (this.previousTimestamp != null && consensusTimestamp.getEpochSecond() / this.exportPeriodSec != this.previousTimestamp.getEpochSecond() / this.exportPeriodSec) {
            this.previousTimestamp = consensusTimestamp;
            return true;
        }
        this.previousTimestamp = consensusTimestamp;
        return false;
    }

    public String exportAccountsBalanceCSVFormat(PlatformTestingToolState state, Instant consensusTimestamp, Path exportDir) {
        logger.debug("exportAccountsBalanceCSVFormat called. {}", (Object)consensusTimestamp);
        MerkleMap<MapKey, MapValueData> accountMap = state.getStateMap().getMap();
        try {
            Files.createDirectories(exportDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "{} doesn't exist and cannot be created", (Object)exportDir);
            throw new IllegalStateException(ex);
        }
        Object fileName = String.valueOf(consensusTimestamp) + "_Balances.csv";
        fileName = ((String)fileName).replace(":", "_");
        Path exportFile = exportDir.resolve((String)fileName);
        ArrayList acctObjList = new ArrayList();
        if (logger.isDebugEnabled()) {
            logger.debug("Size of accountMap :: {}", (Object)accountMap.size());
        }
        accountMap.forEachNode(node -> {
            if (node != null && node.getClassId() == 2336178784194096168L) {
                MapValueData currMv = (MapValueData)node.cast();
                MapKey currKey = currMv.getKey();
                ExportAccountObject exAccObj = new ExportAccountObject(currKey.getShardId(), currKey.getRealmId(), currKey.getAccountId(), currMv.getBalance());
                acctObjList.add(exAccObj);
            }
        });
        Collections.sort(acctObjList, new Comparator<ExportAccountObject>(this){

            @Override
            public int compare(ExportAccountObject o1, ExportAccountObject o2) {
                return (int)(o1.getAccountNum() - o2.getAccountNum());
            }
        });
        try (FileWriter file = new FileWriter(exportFile.toFile());){
            file.write("TimeStamp:");
            file.write(consensusTimestamp.toString());
            file.write(System.getProperty(lineSperator));
            file.write("shardNum,realmNum,accountNum,balance");
            file.write(System.getProperty(lineSperator));
            for (ExportAccountObject exAcctObj : acctObjList) {
                file.write(AccountBalanceExport.getAccountData(exAcctObj));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("periodic export of account data completed :: {}", fileName);
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred while Exporting Accounts to File.. continuing without saving!! {}", (Object)e.getMessage());
        }
        return exportFile.toAbsolutePath().toString();
    }

    private static String getAccountData(ExportAccountObject exportAcctObj) {
        StringBuilder accountData = new StringBuilder();
        accountData.append(exportAcctObj.getShardNum()).append(",").append(exportAcctObj.getRealmNum()).append(",").append(exportAcctObj.getAccountNum()).append(",").append(exportAcctObj.getBalance()).append(System.getProperty(lineSperator));
        return accountData.toString();
    }

    public static byte[] getFileHash(String fileName) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-384");
            byte[] array = new byte[]{};
            try {
                array = Files.readAllBytes(Paths.get(fileName, new String[0]));
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception ", (Throwable)e);
            }
            byte[] fileHash = md.digest(array);
            return fileHash;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception ", (Throwable)e);
            return null;
        }
    }

    public void signAccountBalanceFile(Platform platform, String balanceFileName) {
        byte[] fileHash = AccountBalanceExport.getFileHash(balanceFileName);
        Signature signature = platform.sign(fileHash);
        String sigFileName = AccountBalanceExport.generateSigFile(balanceFileName, signature.getBytes(), fileHash);
        if (sigFileName != null && logger.isDebugEnabled()) {
            logger.debug("Generated signature file for {}", (Object)balanceFileName);
        }
    }

    private static String generateSigFile(String fileName, Bytes signatureBytes, byte[] fileHash) {
        String string;
        byte[] signature = signatureBytes.toByteArray();
        String newFileName = fileName + "_sig";
        FileOutputStream output = new FileOutputStream(newFileName, false);
        try {
            output.write(4);
            output.write(fileHash);
            output.write(3);
            output.write(ByteBuffer.allocate(4).putInt(signature.length).array());
            output.write(signature);
            string = newFileName;
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String message = "generateSigFile :: Fail to generate signature file for %s. Exception:".formatted(fileName);
                logger.error(LogMarker.EXCEPTION.getMarker(), message, (Throwable)e);
                return null;
            }
        }
        output.close();
        return string;
    }
}

