/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.utility.test.fixtures.RandomUtils;

public class CryptoRandomUtils {
    private CryptoRandomUtils() {
    }

    @NonNull
    public static Hash randomHash() {
        return CryptoRandomUtils.randomHash(new Random());
    }

    @NonNull
    public static Hash randomHash(@NonNull Random random) {
        return new Hash(RandomUtils.randomByteArray((Random)random, (int)DigestType.SHA_384.digestLength()), DigestType.SHA_384);
    }

    public static Bytes randomHashBytes(@NonNull Random random) {
        return Bytes.wrap((byte[])RandomUtils.randomByteArray((Random)random, (int)DigestType.SHA_384.digestLength()));
    }

    @NonNull
    public static Signature randomSignature(@NonNull Random random) {
        return new Signature(SignatureType.RSA, RandomUtils.randomByteArray((Random)random, (int)SignatureType.RSA.signatureLength()));
    }

    @NonNull
    public static Bytes randomSignatureBytes(@NonNull Random random) {
        return Bytes.wrap((byte[])RandomUtils.randomByteArray((Random)random, (int)SignatureType.RSA.signatureLength()));
    }
}

