/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.merkledb.files.DataFileCommon;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;

public final class DataFileMetadata {
    private static final FieldDefinition FIELD_INDEX = new FieldDefinition("index", FieldType.UINT32, false, true, false, 1);
    private static final FieldDefinition FIELD_CREATION_SECONDS = new FieldDefinition("creationDateSeconds", FieldType.UINT64, false, false, false, 2);
    private static final FieldDefinition FIELD_CREATION_NANOS = new FieldDefinition("creationDateNanos", FieldType.UINT32, false, false, false, 3);
    @Deprecated
    private static final FieldDefinition FIELD_ITEMS_COUNT = new FieldDefinition("itemsCount", FieldType.FIXED64, false, false, false, 4);
    @Deprecated
    private static final FieldDefinition FIELD_ITEM_VERSION = new FieldDefinition("itemsVersion", FieldType.UINT64, false, true, false, 5);
    private static final FieldDefinition FIELD_COMPACTION_LEVEL = new FieldDefinition("compactionLevel", FieldType.UINT32, false, true, false, 6);
    public static final int MAX_COMPACTION_LEVEL = 127;
    private final int index;
    private final Instant creationDate;
    private final byte compactionLevel;

    public DataFileMetadata(int index, Instant creationDate, int compactionLevel) {
        assert (compactionLevel >= 0 && compactionLevel < 127);
        this.index = index;
        this.creationDate = creationDate;
        this.compactionLevel = (byte)compactionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataFileMetadata readFromFile(Path file) throws IOException {
        int index = 0;
        long creationSeconds = 0L;
        int creationNanos = 0;
        int compactionLevel = 0;
        try (ReadableStreamingData in = new ReadableStreamingData(file);){
            while (in.hasRemaining()) {
                int tag = in.readVarInt(false);
                int fieldNum = tag >> 3;
                if (fieldNum == DataFileCommon.FIELD_DATAFILE_METADATA.number()) {
                    int metadataSize = in.readVarInt(false);
                    long oldLimit = in.limit();
                    in.limit(in.position() + (long)metadataSize);
                    try {
                        while (in.hasRemaining()) {
                            int metadataFieldTag = in.readVarInt(false);
                            int metadataFieldNum = metadataFieldTag >> 3;
                            if (metadataFieldNum == FIELD_INDEX.number()) {
                                index = in.readVarInt(false);
                                continue;
                            }
                            if (metadataFieldNum == FIELD_CREATION_SECONDS.number()) {
                                creationSeconds = in.readVarLong(false);
                                continue;
                            }
                            if (metadataFieldNum == FIELD_CREATION_NANOS.number()) {
                                creationNanos = in.readVarInt(false);
                                continue;
                            }
                            if (metadataFieldNum == FIELD_ITEMS_COUNT.number()) {
                                in.readLong();
                                continue;
                            }
                            if (metadataFieldNum == FIELD_ITEM_VERSION.number()) {
                                in.readVarLong(false);
                                continue;
                            }
                            if (metadataFieldNum == FIELD_COMPACTION_LEVEL.number()) {
                                int compactionLevelInt = in.readVarInt(false);
                                assert (compactionLevelInt < 127);
                                compactionLevel = (byte)compactionLevelInt;
                                continue;
                            }
                            throw new IllegalArgumentException("Unknown data file metadata field: " + metadataFieldNum);
                        }
                        break;
                    }
                    finally {
                        in.limit(oldLimit);
                    }
                }
                if (fieldNum == DataFileCommon.FIELD_DATAFILE_ITEMS.number()) {
                    int size = in.readVarInt(false);
                    in.skip((long)size);
                    continue;
                }
                throw new IllegalArgumentException("Unknown data file field: " + fieldNum);
            }
        }
        if (index == 0 && creationSeconds == 0L && creationNanos == 0) {
            throw new IllegalArgumentException("No metadata found in file: " + String.valueOf(file));
        }
        return new DataFileMetadata(index, Instant.ofEpochSecond(creationSeconds, creationNanos), compactionLevel);
    }

    <T extends WritableSequentialData> void writeTo(T out) {
        ProtoWriterTools.writeDelimited(out, (FieldDefinition)DataFileCommon.FIELD_DATAFILE_METADATA, (int)this.calculateFieldsSizeInBytes(), this::writeFields);
    }

    private <T extends WritableSequentialData> void writeFields(T out) {
        if (this.getIndex() != 0) {
            ProtoWriterTools.writeTag(out, (FieldDefinition)FIELD_INDEX);
            out.writeVarInt(this.getIndex(), false);
        }
        Instant creationInstant = this.getCreationDate();
        ProtoWriterTools.writeTag(out, (FieldDefinition)FIELD_CREATION_SECONDS);
        out.writeVarLong(creationInstant.getEpochSecond(), false);
        ProtoWriterTools.writeTag(out, (FieldDefinition)FIELD_CREATION_NANOS);
        out.writeVarInt(creationInstant.getNano(), false);
        if (this.getCompactionLevel() != 0) {
            ProtoWriterTools.writeTag(out, (FieldDefinition)FIELD_COMPACTION_LEVEL);
            out.writeVarInt((int)this.compactionLevel, false);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Instant getCreationDate() {
        return this.creationDate;
    }

    int metadataSizeInBytes() {
        return ProtoWriterTools.sizeOfDelimited((FieldDefinition)DataFileCommon.FIELD_DATAFILE_METADATA, (int)this.calculateFieldsSizeInBytes());
    }

    private int calculateFieldsSizeInBytes() {
        int size = 0;
        if (this.index != 0) {
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_INDEX, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
            size += ProtoWriterTools.sizeOfVarInt32((int)this.index);
        }
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_CREATION_SECONDS, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        size += ProtoWriterTools.sizeOfVarInt64((long)this.creationDate.getEpochSecond());
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_CREATION_NANOS, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        size += ProtoWriterTools.sizeOfVarInt64((long)this.creationDate.getNano());
        if (this.compactionLevel != 0) {
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_COMPACTION_LEVEL, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
            size += ProtoWriterTools.sizeOfVarInt32((int)this.compactionLevel);
        }
        return size;
    }

    public int getCompactionLevel() {
        return this.compactionLevel;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("index", (Object)this.index).append("creationDate", (Object)this.creationDate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFileMetadata that = (DataFileMetadata)o;
        return this.index == that.index && this.compactionLevel == that.compactionLevel && Objects.equals(this.creationDate, that.creationDate);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.creationDate, this.compactionLevel);
    }
}

