/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.validation.ConfigPropertyConstraint;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.api.validation.PropertyMetadata;
import com.swirlds.config.impl.internal.ConverterService;
import com.swirlds.config.impl.internal.PropertyMetadataImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

final class ConstraintValidator
implements ConfigValidator {
    private final ConverterService converterService;
    private final Queue<ConfigPropertyConstraintData> constraintData;

    ConstraintValidator(@NonNull ConverterService converterService) {
        this.converterService = Objects.requireNonNull(converterService, "converterService must not be null");
        this.constraintData = new ConcurrentLinkedQueue<ConfigPropertyConstraintData>();
    }

    @NonNull
    public Stream<ConfigViolation> validate(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        return this.constraintData.stream().map(d -> {
            PropertyMetadata propertyMetadata = this.createMetadata(d.propertyName, d.valueType, configuration);
            return d.validator.check(propertyMetadata);
        }).filter(Objects::nonNull);
    }

    @NonNull
    private <T> PropertyMetadata<T> createMetadata(@NonNull String propertyName, @NonNull Class<T> valueType, @NonNull Configuration configuration) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(valueType, "valueType must not be null");
        Objects.requireNonNull(configuration, "configuration must not be null");
        if (configuration.exists(propertyName)) {
            ConfigConverter<T> converter = this.converterService.getConverterForType(valueType);
            return new PropertyMetadataImpl<T>(propertyName, configuration.getValue(propertyName), valueType, true, converter);
        }
        ConfigConverter<T> converter = this.converterService.getConverterForType(valueType);
        return new PropertyMetadataImpl<T>(propertyName, null, valueType, false, converter);
    }

    <T> void addConstraint(@NonNull String propertyName, @NonNull Class<T> valueType, @NonNull ConfigPropertyConstraint<T> validator) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(valueType, "valueType must not be null");
        Objects.requireNonNull(validator, "validator must not be null");
        this.constraintData.add(new ConfigPropertyConstraintData<T>(propertyName, valueType, validator));
    }

    void clear() {
        this.constraintData.clear();
    }

    private record ConfigPropertyConstraintData<T>(String propertyName, Class<T> valueType, ConfigPropertyConstraint<T> validator) {
    }
}

