/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.roster;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;

@Deprecated(forRemoval=true)
public class AddressBook
implements Iterable<Address>,
SelfSerializable,
Hashable {
    public static final int NOT_IN_ADDRESS_BOOK_INDEX = -1;
    public static final long CLASS_ID = 5685030982988856288L;
    public static final int MAX_ADDRESSES = 1024;
    public static final long UNKNOWN_ROUND = Long.MIN_VALUE;
    private long round = Long.MIN_VALUE;
    private NodeId nextNodeId = NodeId.FIRST_NODE_ID;
    private final Map<NodeId, Address> addresses = new HashMap<NodeId, Address>();
    private final Map<String, NodeId> publicKeyToId = new HashMap<String, NodeId>();
    private final Map<NodeId, Integer> nodeIndices = new HashMap<NodeId, Integer>();
    private final List<NodeId> orderedNodeIds = new ArrayList<NodeId>();
    private long totalWeight;
    private int numberWithWeight;
    private Hash hash;

    public AddressBook() {
        this(new ArrayList<Address>());
    }

    private AddressBook(@NonNull AddressBook that) {
        Objects.requireNonNull(that, "AddressBook must not be null");
        for (Address address : that) {
            this.addNewAddress(address);
        }
        this.round = that.round;
        this.nextNodeId = that.nextNodeId;
    }

    public AddressBook(@NonNull List<Address> addresses) {
        Objects.requireNonNull(addresses, "addresses must not be null");
        addresses.forEach(this::add);
    }

    public int getVersion() {
        return 5;
    }

    public long getClassId() {
        return 5685030982988856288L;
    }

    public long getRound() {
        return this.round;
    }

    public AddressBook setRound(long round) {
        this.round = round;
        return this;
    }

    public int getSize() {
        return this.addresses.size();
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public int getNumberWithWeight() {
        return this.numberWithWeight;
    }

    public long getTotalWeight() {
        return this.totalWeight;
    }

    @Nullable
    public NodeId getNodeId(@NonNull String publicKey) {
        Objects.requireNonNull(publicKey, "publicKey must not be null");
        return this.publicKeyToId.get(publicKey);
    }

    @NonNull
    public NodeId getNodeId(int index) {
        if (index < 0 || index >= this.addresses.size()) {
            throw new NoSuchElementException("no address with index " + index + " exists");
        }
        return this.orderedNodeIds.get(index);
    }

    public int getIndexOfNodeId(@NonNull NodeId id) {
        Objects.requireNonNull(id, "nodeId is null");
        return this.nodeIndices.getOrDefault(id, -1);
    }

    public NodeId getNextAvailableNodeId() {
        return this.getSize() == 0 ? NodeId.FIRST_NODE_ID : this.getNodeId(this.getSize() - 1).getOffset(1L);
    }

    @Deprecated(forRemoval=true, since="0.56.0")
    @NonNull
    public NodeId getNextNodeId() {
        return this.nextNodeId;
    }

    @Deprecated(forRemoval=true, since="0.56.0")
    @NonNull
    public AddressBook setNextNodeId(@NonNull NodeId newNextNodeId) {
        this.nextNodeId = newNextNodeId;
        return this;
    }

    @NonNull
    public Address getAddress(@NonNull NodeId id) {
        Objects.requireNonNull(id, "NodeId is null");
        Address address = this.addresses.get(id);
        if (address == null) {
            throw new NoSuchElementException("no address with id " + String.valueOf(id) + " exists");
        }
        return address;
    }

    public boolean contains(@Nullable NodeId id) {
        return id != null && this.addresses.containsKey(id);
    }

    private void addToOrderedList(@NonNull NodeId nodeId) {
        int index = this.orderedNodeIds.size();
        this.orderedNodeIds.add(nodeId);
        this.nodeIndices.put(nodeId, index);
    }

    private void removeNodeFromOrderedList(@NonNull NodeId nodeId) {
        int indexToRemove = this.nodeIndices.remove(nodeId);
        this.orderedNodeIds.remove(indexToRemove);
        for (int index = indexToRemove; index < this.orderedNodeIds.size(); ++index) {
            this.nodeIndices.put(this.orderedNodeIds.get(index), index);
        }
    }

    public void updateWeight(@NonNull NodeId id, long weight) {
        Objects.requireNonNull(id, "NodeId is null");
        Address address = this.getAddress(id);
        if (weight < 0L) {
            throw new IllegalArgumentException("weight must be nonnegative");
        }
        this.updateAddress(address.copySetWeight(weight));
    }

    private void updateAddress(@NonNull Address address) {
        Address oldAddress = Objects.requireNonNull(this.addresses.put(address.getNodeId(), address));
        this.publicKeyToId.remove(oldAddress.getNickname());
        this.publicKeyToId.put(address.getNickname(), address.getNodeId());
        long oldWeight = oldAddress.getWeight();
        long newWeight = address.getWeight();
        this.totalWeight -= oldWeight;
        this.totalWeight += newWeight;
        if (oldWeight == 0L && newWeight != 0L) {
            ++this.numberWithWeight;
        } else if (oldWeight != 0L && newWeight == 0L) {
            --this.numberWithWeight;
        }
        this.addresses.put(address.getNodeId(), address);
    }

    private void addNewAddress(@NonNull Address address) {
        int addressBookSize;
        NodeId nextAvailable;
        NodeId addressNodeId = address.getNodeId();
        int nodeIdComparison = addressNodeId.compareTo(nextAvailable = (addressBookSize = this.getSize()) == 0 ? NodeId.FIRST_NODE_ID : this.getNodeId(this.getSize() - 1).getOffset(1L));
        if (nodeIdComparison < 0) {
            throw new IllegalArgumentException("Can not add address with node ID " + String.valueOf(address.getNodeId()) + ", the next address to be added is required have a node ID greater or equal to " + String.valueOf(nextAvailable));
        }
        if (this.addresses.size() >= 1024) {
            throw new IllegalStateException("Address book is only permitted to hold 1024 entries");
        }
        this.addresses.put(address.getNodeId(), address);
        this.publicKeyToId.put(address.getNickname(), address.getNodeId());
        this.addToOrderedList(address.getNodeId());
        this.totalWeight += address.getWeight();
        if (!address.isZeroWeight()) {
            ++this.numberWithWeight;
        }
    }

    @NonNull
    public AddressBook add(@NonNull Address address) {
        Objects.requireNonNull(address, "address must not be null");
        if (this.addresses.containsKey(address.getNodeId())) {
            this.updateAddress(address);
        } else {
            this.addNewAddress(address);
        }
        return this;
    }

    @NonNull
    public AddressBook remove(@NonNull NodeId id) {
        Objects.requireNonNull(id, "NodeId is null");
        Address address = this.addresses.remove(id);
        if (address == null) {
            return this;
        }
        this.publicKeyToId.remove(address.getNickname());
        this.removeNodeFromOrderedList(id);
        this.totalWeight -= address.getWeight();
        if (!address.isZeroWeight()) {
            --this.numberWithWeight;
        }
        this.orderedNodeIds.remove(id);
        return this;
    }

    public void clear() {
        this.addresses.clear();
        this.publicKeyToId.clear();
        this.nodeIndices.clear();
        this.orderedNodeIds.clear();
        this.totalWeight = 0L;
        this.numberWithWeight = 0;
        this.nextNodeId = NodeId.FIRST_NODE_ID;
    }

    @NonNull
    public AddressBook copy() {
        return new AddressBook(this);
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        Objects.requireNonNull(out, "out must not be null");
        out.writeSerializableIterableWithSize(this.iterator(), this.addresses.size(), false, true);
        out.writeLong(this.round);
        out.writeSerializable((SelfSerializable)this.nextNodeId, false);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        Objects.requireNonNull(in, "in must not be null");
        in.readSerializableIterableWithSize(1024, false, Address::new, this::addNewAddress);
        this.round = in.readLong();
        this.nextNodeId = version < 5 ? NodeId.of(in.readLong()) : (NodeId)in.readSerializable(false, NodeId::new);
    }

    public int getMinimumSupportedVersion() {
        return 4;
    }

    @Override
    @NonNull
    public Iterator<Address> iterator() {
        return new AddressBookIterator(this.orderedNodeIds.iterator(), this.addresses);
    }

    @NonNull
    public Set<NodeId> getNodeIdSet() {
        return new HashSet<NodeId>(this.addresses.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressBook that = (AddressBook)o;
        return Objects.equals(this.addresses, that.addresses) && this.getRound() == that.getRound();
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public int hashCode() {
        return this.addresses.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressBook {\n");
        for (Address address : this) {
            sb.append("   ").append(address).append(",\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 0;
        public static final int UNDOCUMENTED = 1;
        public static final int AD_HOC_SERIALIZATION = 2;
        public static final int UTILITY_SERIALIZATION = 3;
        public static final int ADDRESS_BOOK_STORE_SUPPORT = 4;
        public static final int SELF_SERIALIZABLE_NODE_ID = 5;

        private ClassVersion() {
        }
    }

    public static class AddressBookIterator
    implements Iterator<Address> {
        private final Iterator<NodeId> orderedNodeIds;
        private final Map<NodeId, Address> addresses;

        public AddressBookIterator(@NonNull Iterator<NodeId> orderedNodeIds, @NonNull Map<NodeId, Address> addresses) {
            this.orderedNodeIds = Objects.requireNonNull(orderedNodeIds, "the orderedNodeIds cannot be null");
            this.addresses = Objects.requireNonNull(addresses, "the addresses cannot be null");
        }

        @Override
        public boolean hasNext() {
            return this.orderedNodeIds.hasNext();
        }

        @Override
        public Address next() {
            return Objects.requireNonNull(this.addresses.get(this.orderedNodeIds.next()));
        }
    }
}

