/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.components.consensus;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.Consensus;
import com.swirlds.platform.ConsensusImpl;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.components.consensus.FreezeRoundController;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.EventWindowUtils;
import com.swirlds.platform.event.linking.ConsensusLinker;
import com.swirlds.platform.freeze.FreezeCheckHolder;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.ConsensusEngineMetrics;
import com.swirlds.platform.metrics.ConsensusMetricsImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.event.FutureEventBuffer;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultConsensusEngine
implements ConsensusEngine {
    private final ConsensusLinker linker;
    private final FutureEventBuffer futureEventBuffer;
    private final Consensus consensus;
    private final int roundsNonAncient;
    private final ConsensusEngineMetrics metrics;
    private final FreezeRoundController freezeRoundController;

    public DefaultConsensusEngine(@NonNull PlatformContext platformContext, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull FreezeCheckHolder freezeChecker) {
        ConsensusMetricsImpl consensusMetrics = new ConsensusMetricsImpl(selfId, platformContext.getMetrics());
        this.consensus = new ConsensusImpl(platformContext, consensusMetrics, roster);
        this.linker = new ConsensusLinker(platformContext);
        this.futureEventBuffer = new FutureEventBuffer(platformContext.getMetrics(), FutureEventBufferingOption.PENDING_CONSENSUS_ROUND, "consensus");
        this.roundsNonAncient = ((ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class)).roundsNonAncient();
        this.metrics = new ConsensusEngineMetrics(selfId, platformContext.getMetrics());
        this.freezeRoundController = new FreezeRoundController(freezeChecker);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.consensus.setPcesMode(platformStatus == PlatformStatus.REPLAYING_EVENTS);
    }

    @Override
    @NonNull
    public ConsensusEngineOutput addEvent(@NonNull PlatformEvent event) {
        Objects.requireNonNull(event);
        if (this.freezeRoundController.isFrozen()) {
            return ConsensusEngineOutput.emptyInstance();
        }
        PlatformEvent consensusRelevantEvent = this.futureEventBuffer.addEvent(event);
        if (consensusRelevantEvent == null) {
            return ConsensusEngineOutput.emptyInstance();
        }
        LinkedList<PlatformEvent> eventsToAdd = new LinkedList<PlatformEvent>();
        ArrayList<PlatformEvent> preConsensusEvents = new ArrayList<PlatformEvent>();
        eventsToAdd.add(consensusRelevantEvent);
        ArrayList<ConsensusRound> allConsensusRounds = new ArrayList<ConsensusRound>();
        ArrayList<PlatformEvent> staleEvents = new ArrayList<PlatformEvent>();
        while (!eventsToAdd.isEmpty()) {
            PlatformEvent eventToAdd = (PlatformEvent)eventsToAdd.poll();
            EventImpl linkedEvent = this.linker.linkEvent(eventToAdd);
            if (linkedEvent == null) continue;
            boolean waitingForJudgesBeforeAdd = this.consensus.waitingForInitJudges();
            allConsensusRounds.addAll(this.consensus.addEvent(linkedEvent));
            boolean waitingForJudgesAfterAdd = this.consensus.waitingForInitJudges();
            this.metrics.eventAdded(linkedEvent);
            if (waitingForJudgesAfterAdd) {
                return ConsensusEngineOutput.emptyInstance();
            }
            if (waitingForJudgesBeforeAdd) {
                allConsensusRounds.stream().map(ConsensusRound::getConsensusEvents).flatMap(Collection::stream).forEach(preConsensusEvents::add);
                this.consensus.getPreConsensusEvents().stream().map(EventImpl::getBaseEvent).forEach(preConsensusEvents::add);
            } else {
                preConsensusEvents.add(linkedEvent.getBaseEvent());
            }
            if (allConsensusRounds.isEmpty()) continue;
            EventWindow eventWindow = ((ConsensusRound)allConsensusRounds.getLast()).getEventWindow();
            List<EventImpl> ancientEvents = this.linker.setEventWindow(eventWindow);
            ancientEvents.stream().filter(e -> !e.isConsensus()).map(EventImpl::getBaseEvent).forEach(staleEvents::add);
            eventsToAdd.addAll(this.futureEventBuffer.updateEventWindow(eventWindow));
        }
        List<ConsensusRound> modifiedRounds = this.freezeRoundController.filterAndModify(allConsensusRounds);
        staleEvents.forEach(this.metrics::reportStaleEvent);
        return new ConsensusEngineOutput(modifiedRounds, preConsensusEvents, staleEvents);
    }

    @Override
    public void outOfBandSnapshotUpdate(@NonNull ConsensusSnapshot snapshot) {
        EventWindow eventWindow = EventWindowUtils.createEventWindow(snapshot, this.roundsNonAncient);
        this.linker.clear();
        this.linker.setEventWindow(eventWindow);
        this.futureEventBuffer.clear();
        this.futureEventBuffer.updateEventWindow(eventWindow);
        this.consensus.loadSnapshot(snapshot);
    }
}

