/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Objects;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.ordered.primitive.ReversibleCharIterable;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;

public interface CharList
extends ReversibleCharIterable {
    public char get(int var1);

    public long dotProduct(CharList var1);

    public int binarySearch(char var1);

    public int lastIndexOf(char var1);

    @Override
    public CharList select(CharPredicate var1);

    @Override
    public CharList reject(CharPredicate var1);

    @Override
    default public CharList tap(CharProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    default public void forEachInBoth(CharList other, CharCharProcedure procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two CharList instances of different sizes :" + this.size() + ":" + other.size());
        }
        this.forEachWithIndex((each, index) -> procedure.value(each, other.get(index)));
    }

    @Override
    default public CharList selectWithIndex(CharIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public CharList rejectWithIndex(CharIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> ListIterable<V> collect(CharToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(CharIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((char each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableCharList toImmutable();

    @Override
    public CharList distinct();

    @Override
    public CharList toReversed();

    public CharList subList(int var1, int var2);

    default public ListIterable<CharCharPair> zipChar(CharIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<CharObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }
}

