/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SimpleConfigSource;
import com.swirlds.demo.consistency.ConsistencyTestingToolConfig;
import com.swirlds.demo.consistency.ConsistencyTestingToolConsensusStateEventHandler;
import com.swirlds.demo.consistency.ConsistencyTestingToolState;
import com.swirlds.demo.consistency.TransactionGenerator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.DefaultSwirldMain;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class ConsistencyTestingToolMain
extends DefaultSwirldMain<ConsistencyTestingToolState> {
    private static final Logger logger = LogManager.getLogger(ConsistencyTestingToolMain.class);
    private static final SemanticVersion semanticVersion = SemanticVersion.newBuilder().major(1).build();
    static final Configuration CONFIGURATION = ConfigurationBuilder.create().autoDiscoverExtensions().withSource((ConfigSource)new SimpleConfigSource().withValue("merkleDb.initialCapacity", Integer.valueOf(1000000))).build();
    private Platform platform;
    private static final int TRANSACTIONS_PER_SECOND = 100;

    public ConsistencyTestingToolMain() {
        logger.info(LogMarker.STARTUP.getMarker(), "constructor called in Main.");
    }

    public void init(@NonNull Platform platform, @NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId);
        this.platform = Objects.requireNonNull(platform);
        logger.info(LogMarker.STARTUP.getMarker(), "init called in Main for node {}.", (Object)nodeId);
    }

    public void run() {
        logger.info(LogMarker.STARTUP.getMarker(), "run called in Main.");
        new TransactionGenerator(new SecureRandom(), this.platform, this.getTransactionPool(), 100).start();
    }

    @NonNull
    public ConsistencyTestingToolState newStateRoot() {
        ConsistencyTestingToolState state = new ConsistencyTestingToolState(CONFIGURATION, StaticPlatformBuilder.getGlobalMetrics());
        TestingAppStateInitializer.initConsensusModuleStates((MerkleNodeState)state, (Configuration)CONFIGURATION);
        return state;
    }

    public Function<VirtualMap, ConsistencyTestingToolState> stateRootFromVirtualMap() {
        return virtualMap -> {
            ConsistencyTestingToolState state = new ConsistencyTestingToolState((VirtualMap)virtualMap);
            TestingAppStateInitializer.initConsensusModuleStates((MerkleNodeState)state, (Configuration)CONFIGURATION);
            return state;
        };
    }

    @NonNull
    public ConsensusStateEventHandler<ConsistencyTestingToolState> newConsensusStateEvenHandler() {
        return new ConsistencyTestingToolConsensusStateEventHandler(new PlatformStateFacade());
    }

    @NonNull
    public SemanticVersion getSemanticVersion() {
        logger.info(LogMarker.STARTUP.getMarker(), "returning software version {}", (Object)semanticVersion);
        return semanticVersion;
    }

    @Nullable
    public List<Class<? extends Record>> getConfigDataTypes() {
        return List.of(ConsistencyTestingToolConfig.class);
    }
}

