/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.rpc;

import com.hedera.hapi.platform.message.GossipEventWindow;
import com.hedera.hapi.platform.message.GossipSyncData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.stream.Collectors;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.hashgraph.EventWindow;

public record SyncData(EventWindow eventWindow, List<Hash> tipHashes, boolean dontReceiveEvents) {
    public static SyncData fromProtobuf(@NonNull GossipSyncData syncData) {
        GossipEventWindow gossipWindow = syncData.window();
        EventWindow eventWindow = new EventWindow(gossipWindow.latestConsensusRound(), gossipWindow.latestConsensusRound() + 1L, gossipWindow.ancientThreshold(), gossipWindow.expiredThreshold());
        List<Hash> tips = syncData.tips().stream().map(it -> new Hash(it.toByteArray())).collect(Collectors.toList());
        return new SyncData(eventWindow, tips, syncData.skipSendingEvents());
    }

    public GossipSyncData toProtobuf() {
        GossipSyncData.Builder builder = GossipSyncData.newBuilder();
        builder.window(GossipEventWindow.newBuilder().ancientThreshold(this.eventWindow.ancientThreshold()).expiredThreshold(this.eventWindow.expiredThreshold()).latestConsensusRound(this.eventWindow.latestConsensusRound()).build());
        builder.tips(this.tipHashes.stream().map(Hash::getBytes).collect(Collectors.toList()));
        builder.skipSendingEvents(this.dontReceiveEvents);
        return builder.build();
    }
}

