/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.platform;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.io.utility.RecycleBinImpl;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.common.test.fixtures.TestRecycleBin;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;
import java.util.Optional;

public class TestPlatformContexts {
    @NonNull
    public static PlatformContext context(@NonNull Time time, Path dataDir) {
        Configuration configuration = new TestConfigBuilder().withValue("event.preconsensus.databaseDirectory", (Object)dataDir).withValue("event.preconsensus.preferredFileSizeMegabytes", 5).withValue("event.preconsensus.permitGaps", false).withValue("event.preconsensus.compactLastFileOnStartup", false).getOrCreateConfig();
        return TestPlatformContextBuilder.create().withConfiguration(configuration).withTime(time).build();
    }

    @NonNull
    public static PlatformContext context(boolean permitGaps, @Nullable Path recycleBinPath, @NonNull Path dataDir, @Nullable Path fsDirectory) {
        Configuration configuration = new TestConfigBuilder().withValue("event.preconsensus.databaseDirectory", (Object)dataDir).withValue("event.preconsensus.preferredFileSizeMegabytes", 5).withValue("event.preconsensus.permitGaps", permitGaps).withValue("event.preconsensus.compactLastFileOnStartup", false).getOrCreateConfig();
        NoOpMetrics metrics = new NoOpMetrics();
        RecycleBin recycleBin = Optional.ofNullable(recycleBinPath).map(arg_0 -> TestPlatformContexts.lambda$context$0((Metrics)metrics, recycleBinPath, arg_0)).orElseGet(TestRecycleBin::getInstance);
        TestPlatformContextBuilder builder = TestPlatformContextBuilder.create().withConfiguration(configuration).withMetrics((Metrics)metrics).withTime(Time.getCurrent()).withRecycleBin(recycleBin);
        Optional.ofNullable(fsDirectory).ifPresent(builder::withTestFileSystemManagerUnder);
        return builder.build();
    }

    @NonNull
    public static PlatformContext context(Path dataDir, Path fsDirectory) {
        return TestPlatformContexts.context(false, dataDir, fsDirectory);
    }

    @NonNull
    public static PlatformContext context(boolean permitGaps, Path dataDir, Path fsDirectory) {
        return TestPlatformContexts.context(permitGaps, null, dataDir, fsDirectory);
    }

    private static /* synthetic */ RecycleBin lambda$context$0(Metrics metrics, Path recycleBinPath, Path p) {
        return new RecycleBinImpl(metrics, AdHocThreadManager.getStaticThreadManager(), Time.getCurrent(), recycleBinPath, TestRecycleBin.MAXIMUM_FILE_AGE, TestRecycleBin.MINIMUM_PERIOD);
    }
}

