/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    private FileUtils() {
    }

    public static void checkOrCreateParentDirectory(@NonNull Path path) {
        try {
            String pathString = path.toFile().getCanonicalPath();
            File file = new File(pathString);
            File dir = file.getParentFile();
            if (!dir.exists()) {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            } else {
                if (dir.exists() && !dir.isDirectory()) {
                    throw new IllegalStateException("Path for Log directory is not a directory. Path:" + String.valueOf(dir));
                }
                if (!dir.canWrite()) {
                    throw new IllegalStateException("Cannot write log directory. Dir:" + String.valueOf(dir));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write to log directory. Path:" + String.valueOf(path), e);
        }
    }
}

