/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.config;

import com.swirlds.base.time.Time;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class QueueThreadMetricsConfiguration {
    private final Metrics metrics;
    private String category = "internal";
    private Time time = Time.getCurrent();
    private boolean maxSizeMetricEnabled;
    private boolean minSizeMetricEnabled;
    private boolean busyTimeMetricEnabled;

    public QueueThreadMetricsConfiguration(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics must not be null");
    }

    @NonNull
    public QueueThreadMetricsConfiguration setCategory(@NonNull String category) {
        this.category = category;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration setTime(@NonNull Time time) {
        this.time = time;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableMaxSizeMetric() {
        this.maxSizeMetricEnabled = true;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableMinSizeMetric() {
        this.minSizeMetricEnabled = true;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableBusyTimeMetric() {
        this.busyTimeMetricEnabled = true;
        return this;
    }

    @NonNull
    public Metrics getMetrics() {
        return this.metrics;
    }

    @NonNull
    public String getCategory() {
        return this.category;
    }

    @NonNull
    public Time getTime() {
        return this.time;
    }

    public boolean isMaxSizeMetricEnabled() {
        return this.maxSizeMetricEnabled;
    }

    public boolean isMinSizeMetricEnabled() {
        return this.minSizeMetricEnabled;
    }

    public boolean isBusyTimeMetricEnabled() {
        return this.busyTimeMetricEnabled;
    }
}

