/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.swirlds.demo.iss.PlannedIncident;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;

public class PlannedLogError
implements SelfSerializable,
PlannedIncident {
    private static final long CLASS_ID = -1096984484627583276L;
    private Duration timeAfterGenesis;
    private List<NodeId> nodeIds;

    public PlannedLogError() {
    }

    public PlannedLogError(@NonNull Duration timeAfterGenesis, @NonNull List<NodeId> nodeIds) {
        this.timeAfterGenesis = Objects.requireNonNull(timeAfterGenesis);
        this.nodeIds = Objects.requireNonNull(nodeIds);
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.timeAfterGenesis.toNanos());
        out.writeSerializableList(this.nodeIds, false, true);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.timeAfterGenesis = Duration.ofNanos(in.readLong());
        this.nodeIds = in.readSerializableList(1024, false, NodeId::new);
    }

    public long getClassId() {
        return -1096984484627583276L;
    }

    public int getVersion() {
        return 1;
    }

    @NonNull
    public static PlannedLogError fromString(@NonNull String plannedLogErrorString) {
        String[] timestampAndNodesStrings = plannedLogErrorString.strip().split(":");
        int elapsedSeconds = Integer.parseInt(timestampAndNodesStrings[0]);
        String[] nodeIdsStrings = timestampAndNodesStrings[1].split("-");
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>();
        for (String nodeIdString : nodeIdsStrings) {
            nodeIds.add(NodeId.of((long)Integer.parseInt(nodeIdString)));
        }
        return new PlannedLogError(Duration.ofSeconds(elapsedSeconds), nodeIds);
    }

    @Override
    @NonNull
    public Duration getTimeAfterGenesis() {
        return this.timeAfterGenesis;
    }

    @Override
    @NonNull
    public String getDescriptor() {
        return "Log Error";
    }

    @NonNull
    public List<NodeId> getNodeIds() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

