/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.tree;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleCopy;
import com.swirlds.common.merkle.copy.MerklePathReplacement;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.utility.MerkleLong;
import com.swirlds.common.merkle.utility.MerkleUtils;
import com.swirlds.merkle.tree.MerkleTreeInternalNode;
import com.swirlds.merkle.tree.internal.BitUtil;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MerkleBinaryTree<T extends MerkleNode>
extends PartialBinaryMerkleInternal
implements Iterable<T>,
MerkleInternal {
    public static final long CLASS_ID = -8881449756281471252L;
    private static final int SIMPLE_TREE_SIZE = 2;
    private T rightMostLeaf;

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: {
                return childClassId == 5101867068740213836L;
            }
            case 1: {
                return childClassId == 1953444780092841751L;
            }
        }
        throw new IllegalChildIndexException(this.getMinimumChildCount(), this.getMaximumChildCount(), index);
    }

    private MerkleLong getSize() {
        return (MerkleLong)this.getChild(0);
    }

    public void setSize(MerkleLong size) {
        this.throwIfImmutable();
        this.setChild(0, (MerkleNode)size);
    }

    public MerkleTreeInternalNode getRoot() {
        return (MerkleTreeInternalNode)this.getChild(1);
    }

    private void setRoot(MerkleTreeInternalNode root) {
        this.setChild(1, (MerkleNode)root);
        this.invalidateHash();
    }

    public MerkleBinaryTree() {
        this(new MerkleLong(0L), new MerkleTreeInternalNode());
    }

    private MerkleBinaryTree(MerkleLong size, MerkleTreeInternalNode root) {
        this.setSize(size);
        this.setRoot(root);
    }

    protected MerkleBinaryTree(MerkleBinaryTree<T> otherMerkleTree) {
        super(otherMerkleTree);
        this.setSize(otherMerkleTree.getSize().copy());
        this.setRoot(new MerkleTreeInternalNode());
        MerkleCopy.adoptChildren((MerkleInternal)otherMerkleTree.getRoot(), (MerkleInternal)this.getRoot());
        this.rightMostLeaf = otherMerkleTree.rightMostLeaf;
        otherMerkleTree.rightMostLeaf = null;
        this.setImmutable(false);
        otherMerkleTree.setImmutable(true);
    }

    public MerkleBinaryTree<T> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        return new MerkleBinaryTree<T>(this);
    }

    public void clear() {
        this.throwIfImmutable();
        this.setSize(new MerkleLong(0L));
        this.setRoot(new MerkleTreeInternalNode());
    }

    public void delete(T leafToDelete, Consumer<T> updateCache) {
        this.throwIfImmutable();
        if (leafToDelete == null) {
            throw new IllegalArgumentException("Delete does not support null leaves");
        }
        if (this.getSize().getValue() <= 2L) {
            this.deleteLeafFromBasicTree(leafToDelete, updateCache);
        } else {
            this.deleteLeaf(leafToDelete, updateCache);
        }
        this.getSize().decrement();
        this.setRightMostLeaf();
    }

    private void deleteRightMostLeaf(Consumer<T> updateCache) {
        MerkleNode[] path = MerklePathReplacement.replacePath((MerkleNode)this.getRoot(), (MerkleRoute)this.rightMostLeaf.getRoute(), (int)2);
        MerkleTreeInternalNode parentOfRightMostLeaf = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
        MerkleNode siblingOfRightMostLeaf = parentOfRightMostLeaf.getLeft().cast();
        MerkleTreeInternalNode grandparentOfRightMostLeaf = (MerkleTreeInternalNode)MerklePathReplacement.getGrandparentInPath((MerkleNode[])path);
        int indexOfParentInGrandparent = MerkleUtils.findChildPositionInParent((MerkleInternal)grandparentOfRightMostLeaf, (MerkleNode)parentOfRightMostLeaf);
        MerkleNode copy = MerkleCopy.copyTreeToLocation((MerkleInternal)grandparentOfRightMostLeaf, (int)indexOfParentInGrandparent, (MerkleNode)siblingOfRightMostLeaf);
        updateCache.accept(copy);
    }

    private void deleteRightMostLeafSibling(MerkleNode[] path, MerkleNode parentOfRightMostLeaf, Consumer<T> updateCache) {
        MerkleTreeInternalNode grandparentOfRightMostLeaf = (MerkleTreeInternalNode)MerklePathReplacement.getGrandparentInPath((MerkleNode[])path);
        int indexOfParentInGrandparent = MerkleUtils.findChildPositionInParent((MerkleInternal)grandparentOfRightMostLeaf, (MerkleNode)parentOfRightMostLeaf);
        MerkleNode copy = MerkleCopy.copyTreeToLocation((MerkleInternal)grandparentOfRightMostLeaf, (int)indexOfParentInGrandparent, this.rightMostLeaf);
        updateCache.accept(copy);
    }

    private void deleteMiddleLeaf(MerkleTreeInternalNode parentOfNodeToDelete, T leafToDelete, Consumer<T> updateCache) {
        int indexOfChildToDelete = MerkleUtils.findChildPositionInParent((MerkleInternal)parentOfNodeToDelete, leafToDelete);
        MerkleNode copy = MerkleCopy.copyTreeToLocation((MerkleInternal)parentOfNodeToDelete, (int)indexOfChildToDelete, this.rightMostLeaf);
        updateCache.accept(copy);
        this.deleteRightMostLeaf(updateCache);
    }

    private void deleteNonRightMostLeaf(T leafToDelete, Consumer<T> updateCache) {
        MerkleNode[] path = MerklePathReplacement.replacePath((MerkleNode)this.getRoot(), (MerkleRoute)leafToDelete.getRoute(), (int)1);
        MerkleTreeInternalNode parentOfNodeToDelete = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
        if (parentOfNodeToDelete.getRight() == this.rightMostLeaf) {
            this.deleteRightMostLeafSibling(path, (MerkleNode)parentOfNodeToDelete, updateCache);
        } else {
            this.deleteMiddleLeaf(parentOfNodeToDelete, leafToDelete, updateCache);
        }
    }

    private void deleteLeaf(T leafToDelete, Consumer<T> updateCache) {
        if (this.rightMostLeaf == leafToDelete) {
            this.deleteRightMostLeaf(updateCache);
        } else {
            this.deleteNonRightMostLeaf(leafToDelete, updateCache);
        }
    }

    private void deleteLeafFromBasicTree(T leafToDelete, Consumer<T> updateCache) {
        if (this.getSize().getValue() < 1L) {
            throw new IllegalStateException("The tree is empty. No leaf to delete");
        }
        if (this.getSize().getValue() == 1L) {
            this.getRoot().setLeft(null);
            this.rightMostLeaf = null;
        } else if (this.rightMostLeaf.equals(leafToDelete)) {
            this.getRoot().setRight(null);
            this.rightMostLeaf = this.getRoot().getLeft().cast();
        } else {
            this.rightMostLeaf = MerkleCopy.copyTreeToLocation((MerkleInternal)this.getRoot(), (int)0, this.rightMostLeaf);
            updateCache.accept(this.rightMostLeaf);
            this.getRoot().setRight(null);
        }
    }

    private void setRightMostLeaf() {
        if (this.getSize().getValue() <= 2L) {
            MerkleTreeInternalNode root = this.getRoot();
            this.rightMostLeaf = root.getRight() != null ? root.getRight() : root.getLeft();
        } else {
            long leftMostOneBit = BitUtil.findLeftMostBit(this.getSize().getValue() - 1L);
            MerkleTreeInternalNode node = (MerkleTreeInternalNode)((Object)MerkleBinaryTree.findFirstLeafAtCompleteSubtree(leftMostOneBit, this.getSize().getValue() - 1L, this.getRoot()));
            this.rightMostLeaf = node.getRight().cast();
        }
    }

    public void update(T oldLeaf, T newLeaf) {
        this.throwIfImmutable();
        if (oldLeaf == null || newLeaf == null) {
            throw new IllegalArgumentException("Update does not support null leaves");
        }
        if (this.getSize().getValue() < 1L) {
            throw new IllegalStateException("The tree is empty. No leaf to replace");
        }
        MerkleNode[] path = MerklePathReplacement.replacePath((MerkleNode)this.getRoot(), (MerkleRoute)oldLeaf.getRoute(), (int)1);
        MerkleTreeInternalNode parent = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
        int indexOfChildInParent = MerkleUtils.findChildPositionInParent((MerkleInternal)parent, oldLeaf);
        parent.setChild(indexOfChildInParent, (MerkleNode)newLeaf, oldLeaf.getRoute(), false);
        if (this.rightMostLeaf == oldLeaf) {
            this.rightMostLeaf = newLeaf;
        }
    }

    private void insertIntoEmptyTree(T leaf) {
        this.getRoot().setLeft((MerkleNode)leaf);
        this.rightMostLeaf = leaf;
    }

    private void insertIntoTreeWithOneLeaf(T leaf) {
        this.getRoot().setRight((MerkleNode)leaf);
        this.rightMostLeaf = leaf;
    }

    public void insert(T entry, Consumer<T> updateCache) {
        this.throwIfImmutable();
        if (this.getSize().getValue() == 0L) {
            this.insertIntoEmptyTree(entry);
        } else if (this.getSize().getValue() == 1L) {
            this.insertIntoTreeWithOneLeaf(entry);
        } else {
            MerkleNode nodeToPush = (MerkleNode)MerkleBinaryTree.findFirstLeafAtCompleteSubtree(BitUtil.findLeftMostBit(this.getSize().getValue()), this.getSize().getValue(), this.getRoot());
            nodeToPush.reserve();
            MerkleNode[] path = MerklePathReplacement.replacePath((MerkleNode)this.getRoot(), (MerkleRoute)nodeToPush.getRoute(), (int)1);
            MerkleTreeInternalNode parentOfNodeToPush = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
            int childIndexOfNodeToPush = MerkleUtils.findChildPositionInParent((MerkleInternal)parentOfNodeToPush, (MerkleNode)nodeToPush);
            MerkleTreeInternalNode newParent = new MerkleTreeInternalNode();
            parentOfNodeToPush.setChild(childIndexOfNodeToPush, (MerkleNode)newParent);
            MerkleNode copy = MerkleCopy.copyTreeToLocation((MerkleInternal)newParent, (int)0, (MerkleNode)nodeToPush);
            updateCache.accept(copy);
            nodeToPush.release();
            newParent.setRight((MerkleNode)entry);
            this.rightMostLeaf = entry;
        }
        this.getSize().increment();
    }

    private static <R> R findFirstLeafAtCompleteSubtree(long leftMostOneBit, long size, MerkleTreeInternalNode internalNode) {
        MerkleTreeInternalNode node = internalNode;
        leftMostOneBit >>= 1;
        while (leftMostOneBit > 0L) {
            node = (size & leftMostOneBit) == 0L ? node.getLeft() : node.getRight();
            leftMostOneBit >>= 1;
        }
        return (R)node.cast();
    }

    public T findValue(Predicate<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Null predicates are not allowed");
        }
        for (MerkleNode leaf : this) {
            if (!condition.test(leaf)) continue;
            return (T)leaf;
        }
        return null;
    }

    public T getRightMostLeaf() {
        return this.rightMostLeaf;
    }

    public void registerCopy(T original, T copy) {
        if (this.rightMostLeaf == original) {
            this.rightMostLeaf = copy;
        }
    }

    public long size() {
        return this.getSize().getValue();
    }

    public void setSize(long size) {
        this.throwIfImmutable();
        this.setSize(new MerkleLong(size));
    }

    public boolean isEmpty() {
        return this.getSize().getValue() == 0L;
    }

    public String toString() {
        return String.format("[size: %d]", this.getSize().getValue());
    }

    @Override
    public MerkleIterator<T> iterator() {
        return new MerkleIterator((MerkleNode)this.getRoot()).setFilter(MerkleBinaryTree::filter).setDescendantFilter(MerkleBinaryTree::descendantFilter);
    }

    private static boolean filter(MerkleNode node) {
        return node.getClassId() != 1953444780092841751L;
    }

    private static boolean descendantFilter(MerkleInternal node) {
        return node.getClassId() == 1953444780092841751L;
    }

    public long getClassId() {
        return -8881449756281471252L;
    }

    public int getVersion() {
        return 1;
    }

    public void rebuild() {
        this.setRightMostLeaf();
    }

    private static class ChildIndices {
        public static final int SIZE = 0;
        public static final int ROOT = 1;
        public static final int CHILD_COUNT = 2;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

