/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.legacy.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.logging.legacy.payload.AbstractLogPayload;
import com.swirlds.logging.legacy.payload.LogPayload;
import java.time.Instant;
import java.util.Objects;

public class JsonLogEntry {
    private final Instant timestamp;
    private final String thread;
    private final String level;
    private final String loggerName;
    private final String marker;
    private final String exceptionType;
    private final String exceptionMessage;
    private final String payload;

    public JsonLogEntry(JsonNode node) {
        long seconds = Long.parseLong(node.get("instant").get("epochSecond").asText());
        long nanoseconds = Long.parseLong(node.get("instant").get("nanoOfSecond").asText());
        this.timestamp = Instant.ofEpochSecond(seconds, nanoseconds);
        this.thread = node.get("thread").asText();
        this.level = node.get("level").asText();
        this.loggerName = node.get("loggerName").asText();
        this.marker = node.get("marker").get("name").asText();
        if (node.has("thrown")) {
            this.exceptionType = node.get("thrown").get("name").asText();
            JsonNode exceptionMessageField = node.get("thrown").get("message");
            this.exceptionMessage = exceptionMessageField != null && !exceptionMessageField.isNull() ? exceptionMessageField.asText() : "";
        } else {
            this.exceptionType = null;
            this.exceptionMessage = null;
        }
        this.payload = node.get("message").asText();
    }

    public JsonLogEntry(Instant timestamp, String thread, String level, String loggerName, String marker, String exceptionType, String exceptionMessage, String payload) {
        this.timestamp = timestamp;
        this.thread = thread;
        this.level = level;
        this.loggerName = loggerName;
        this.marker = marker;
        this.exceptionType = exceptionType;
        this.exceptionMessage = exceptionMessage;
        this.payload = payload;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getThread() {
        return this.thread;
    }

    public String getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean hasException() {
        return this.exceptionType != null;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getRawPayload() {
        return this.payload;
    }

    public <T extends LogPayload> T getPayload(Class<T> type) {
        return AbstractLogPayload.parsePayload(type, this.payload);
    }

    public String getPayloadType() {
        return AbstractLogPayload.extractPayloadType(this.payload);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this).append("timestamp", (Object)this.timestamp.toString()).append("thread", (Object)this.thread).append("level", (Object)this.level).append("logger", (Object)this.loggerName).append("marker", (Object)this.marker).append("payload", (Object)this.payload);
        if (this.hasException()) {
            tsb.append("exception type", (Object)this.exceptionType).append("exception message", (Object)this.exceptionMessage);
        }
        return tsb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JsonLogEntry that = (JsonLogEntry)other;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.thread, that.thread) && Objects.equals(this.level, that.level) && Objects.equals(this.loggerName, that.loggerName) && Objects.equals(this.marker, that.marker) && Objects.equals(this.exceptionType, that.exceptionType) && Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.thread, this.level, this.loggerName, this.marker, this.exceptionType, this.exceptionMessage, this.payload);
    }
}

