/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.services.auxiliary.tss.codec;

import com.hedera.hapi.services.auxiliary.tss.TssMessageTransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class TssMessageTransactionBodyJsonCodec
implements JsonCodec<TssMessageTransactionBody> {
    @NonNull
    public TssMessageTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_source_roster_hash = Bytes.EMPTY;
            Bytes temp_target_roster_hash = Bytes.EMPTY;
            long temp_share_index = 0L;
            Bytes temp_tss_message = Bytes.EMPTY;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "sourceRosterHash": {
                        temp_source_roster_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "targetRosterHash": {
                        temp_target_roster_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "shareIndex": {
                        temp_share_index = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "tssMessage": {
                        temp_tss_message = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TssMessageTransactionBody(temp_source_roster_hash, temp_target_roster_hash, temp_share_index, temp_tss_message);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TssMessageTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.sourceRosterHash() != Bytes.EMPTY && data.sourceRosterHash() != null && data.sourceRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"sourceRosterHash", (Bytes)data.sourceRosterHash()));
        }
        if (data.targetRosterHash() != Bytes.EMPTY && data.targetRosterHash() != null && data.targetRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"targetRosterHash", (Bytes)data.targetRosterHash()));
        }
        if (data.shareIndex() != 0L) {
            fieldLines.add(JsonTools.field((String)"shareIndex", (long)data.shareIndex()));
        }
        if (data.tssMessage() != Bytes.EMPTY && data.tssMessage() != null && data.tssMessage().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"tssMessage", (Bytes)data.tssMessage()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

