/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableBooleanSet
extends AbstractMutableSet<Boolean>
implements MutableSet<Boolean> {
    private final MutableBooleanSet delegate;

    public BoxedMutableBooleanSet(MutableBooleanSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Boolean getFirst() {
        throw new UnsupportedOperationException();
    }

    public Boolean getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Boolean> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Boolean item) {
        return this.delegate.add(item.booleanValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Boolean && this.delegate.contains(((Boolean)object).booleanValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Boolean && this.delegate.remove(((Boolean)object).booleanValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Boolean> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Boolean> iterator() {
        return new BoxedPrimitiveBooleanSetIterator(this.delegate.booleanIterator());
    }

    private static final class BoxedPrimitiveBooleanSetIterator
    implements Iterator<Boolean> {
        private final MutableBooleanIterator delegate;

        private BoxedPrimitiveBooleanSetIterator(MutableBooleanIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Boolean next() {
            return this.delegate.next();
        }
    }
}

