/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SimpleConfigSource;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class VirtualMapUtils {
    static final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(MerkleDbConfig.class).withSource((ConfigSource)new SimpleConfigSource().withValue("merkleDb.initialCapacity", "65536")).withConfigDataType(VirtualMapConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();

    public static VirtualMap createVirtualMap(@NonNull String label) {
        return VirtualMapUtils.createVirtualMap(CONFIGURATION, label);
    }

    public static VirtualMap createVirtualMap(@NonNull Configuration configuration, @NonNull String label) {
        long MAX_NUM_OF_KEYS = 1000L;
        return VirtualMapUtils.createVirtualMap(configuration, label, 1000L);
    }

    public static VirtualMap createVirtualMap(@NonNull String label, long maxNumberOfKeys) {
        return VirtualMapUtils.createVirtualMap(CONFIGURATION, label, maxNumberOfKeys);
    }

    public static VirtualMap createVirtualMap(@NonNull Configuration configuration, @NonNull String label, long maxNumberOfKeys) {
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, maxNumberOfKeys, merkleDbConfig.hashesRamToDiskThreshold());
        return new VirtualMap(label, (VirtualDataSourceBuilder)dsBuilder, configuration);
    }
}

