/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.actions;

import com.swirlds.demo.platform.actions.Action;
import com.swirlds.demo.platform.actions.QuorumResult;
import com.swirlds.demo.platform.actions.TriggeredAction;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.hiero.base.io.SelfSerializable;

public class QuorumTriggeredAction<S extends SelfSerializable>
extends TriggeredAction<Long, S> {
    private static final Logger logger = LogManager.getLogger(QuorumTriggeredAction.class);
    private static final Marker LOGM_DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private final long selfId;
    private final int members;
    private final int quorumThreshold;
    private Action<Long, S> lostQuorumAction;
    private QuorumResult<S> quorumResult;

    public QuorumTriggeredAction(long selfId, int members, int quorumThreshold, Action<Long, S> action) {
        this(() -> selfId, () -> members, () -> quorumThreshold, action);
    }

    public QuorumTriggeredAction(LongSupplier selfIdSupplier, IntSupplier membersSupplier, IntSupplier quorumThresholdSupplier, Action<Long, S> action) {
        if (selfIdSupplier == null) {
            throw new IllegalArgumentException("selfIdSupplier");
        }
        if (membersSupplier == null) {
            throw new IllegalArgumentException("membersSupplier");
        }
        if (quorumThresholdSupplier == null) {
            throw new IllegalArgumentException("quorumThresholdSupplier");
        }
        this.selfId = selfIdSupplier.getAsLong();
        this.members = membersSupplier.getAsInt();
        this.quorumThreshold = quorumThresholdSupplier.getAsInt();
        this.quorumResult = new QuorumResult(this.members);
        if (this.quorumThreshold <= 0 && this.members > 0 || this.quorumThreshold > this.members) {
            throw new IndexOutOfBoundsException("quorumThreshold");
        }
        this.withTrigger(this::applyTransition).withAction(action);
    }

    public QuorumResult<S> getQuorumResult() {
        return this.quorumResult;
    }

    public void setQuorumResult(QuorumResult<S> quorumResult) {
        this.quorumResult = quorumResult;
    }

    public int getMembers() {
        return this.members;
    }

    public int getQuorumThreshold() {
        return this.quorumThreshold;
    }

    public boolean hasQuorum() {
        return this.quorumResult.hasQuorum();
    }

    public S getQuorumState() {
        return this.quorumResult.getQuorumState();
    }

    public boolean hasQuorum(S state) {
        return this.hasQuorum() && Objects.equals(state, this.getQuorumState());
    }

    public QuorumTriggeredAction<S> withLostQuorumAction(Action<Long, S> action) {
        this.lostQuorumAction = action;
        return this;
    }

    @Override
    public void reset() {
        this.quorumResult.reset();
    }

    private boolean applyTransition(Long node, S state) {
        logger.info(LOGM_DEMO_INFO, "Node {} apply state {}", (Object)node, state);
        return this.quorumResult.applyTransition(node, state, this.quorumThreshold, this.selfId, this.lostQuorumAction);
    }
}

