/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.consensus.EventWindowUtils;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.SwirldStateManager;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public class ReconnectStateLoader {
    private static final Logger logger = LogManager.getLogger(ReconnectStateLoader.class);
    private final Platform platform;
    private final PlatformContext platformContext;
    private final PlatformCoordinator platformCoordinator;
    private final SwirldStateManager swirldStateManager;
    private final SignedStateNexus latestImmutableStateNexus;
    private final SavedStateController savedStateController;
    private final Roster roster;
    private final ConsensusStateEventHandler consensusStateEventHandler;
    private final PlatformStateFacade platformStateFacade;

    public ReconnectStateLoader(@NonNull Platform platform, @NonNull PlatformContext platformContext, @NonNull PlatformCoordinator platformCoordinator, @NonNull SwirldStateManager swirldStateManager, @NonNull SignedStateNexus latestImmutableStateNexus, @NonNull SavedStateController savedStateController, @NonNull Roster roster, @NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull PlatformStateFacade platformStateFacade) {
        this.platform = Objects.requireNonNull(platform);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.platformCoordinator = Objects.requireNonNull(platformCoordinator);
        this.swirldStateManager = Objects.requireNonNull(swirldStateManager);
        this.latestImmutableStateNexus = Objects.requireNonNull(latestImmutableStateNexus);
        this.savedStateController = Objects.requireNonNull(savedStateController);
        this.roster = Objects.requireNonNull(roster);
        this.consensusStateEventHandler = consensusStateEventHandler;
        this.platformStateFacade = platformStateFacade;
    }

    public void loadReconnectState(@NonNull SignedState signedState) {
        logger.info(LogMarker.STATE_HASH.getMarker(), "RECONNECT: loadReconnectState: reloading state");
        logger.debug(LogMarker.RECONNECT.getMarker(), "`loadReconnectState` : reloading state");
        try {
            this.platformCoordinator.overrideIssDetectorState(signedState.reserve("reconnect state to issDetector"));
            Hash reconnectHash = signedState.getState().getHash();
            MerkleNodeState state = signedState.getState();
            SemanticVersion creationSoftwareVersion = this.platformStateFacade.creationSoftwareVersionOf((State)state);
            signedState.init(this.platformContext);
            this.consensusStateEventHandler.onStateInitialized(state, this.platform, InitTrigger.RECONNECT, creationSoftwareVersion);
            if (!Objects.equals(signedState.getState().getHash(), reconnectHash)) {
                throw new IllegalStateException("State hash is not permitted to change during a reconnect init() call. Previous hash was " + String.valueOf(reconnectHash) + ", new hash is " + String.valueOf(signedState.getState().getHash()));
            }
            long round = this.platformStateFacade.roundOf((State)state);
            Roster stateRoster = RosterRetriever.retrieveActive((State)state, (long)round);
            if (!this.roster.equals((Object)stateRoster)) {
                throw new IllegalStateException("Current roster and state-based roster do not contain the same nodes  (currentRoster=" + Roster.JSON.toJSON((Object)this.roster) + ") (stateRoster=" + Roster.JSON.toJSON((Object)stateRoster) + ")");
            }
            this.swirldStateManager.loadFromSignedState(signedState);
            this.platformCoordinator.submitStatusAction(new ReconnectCompleteAction(signedState.getRound()));
            this.latestImmutableStateNexus.setState(signedState.reserve("set latest immutable to reconnect state"));
            this.savedStateController.reconnectStateReceived(signedState.reserve("savedStateController.reconnectStateReceived"));
            this.platformCoordinator.sendStateToHashLogger(signedState);
            this.platformCoordinator.putSignatureCollectorState(signedState.reserve("loading reconnect state into sig collector"));
            ConsensusSnapshot consensusSnapshot = Objects.requireNonNull(this.platformStateFacade.consensusSnapshotOf((State)state));
            this.platformCoordinator.consensusSnapshotOverride(consensusSnapshot);
            RosterHistory rosterHistory = RosterUtils.createRosterHistory((State)state);
            this.platformCoordinator.injectRosterHistory(rosterHistory);
            this.platformCoordinator.updateEventWindow(EventWindowUtils.createEventWindow(consensusSnapshot, this.platformContext.getConfiguration()));
            RunningEventHashOverride runningEventHashOverride = new RunningEventHashOverride(this.platformStateFacade.legacyRunningEventHashOf((State)state), true);
            this.platformCoordinator.updateRunningHash(runningEventHashOverride);
            this.platformCoordinator.registerPcesDiscontinuity(signedState.getRound());
            this.platformCoordinator.sendReconnectCompleteNotification(signedState);
        }
        catch (RuntimeException e) {
            logger.debug(LogMarker.RECONNECT.getMarker(), "`loadReconnectState` : FAILED, reason: {}", (Object)e.getMessage());
            this.platformCoordinator.clear();
            throw e;
        }
    }
}

