/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.hapi.node.state.primitives.ProtoLong;
import com.hedera.hapi.node.state.primitives.ProtoString;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.demo.iss.ISSTestingToolConfig;
import com.swirlds.demo.iss.PlannedIss;
import com.swirlds.demo.iss.PlannedLogError;
import com.swirlds.demo.iss.V0680ISSTestingToolSchema;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.merkle.disk.OnDiskWritableSingletonState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.hiero.consensus.model.event.ConsensusEvent;

public class ISSTestingToolState
extends VirtualMapState<ISSTestingToolState>
implements MerkleNodeState {
    private long runningSum;
    private Instant genesisTimestamp;
    private List<PlannedIss> plannedIssList = new LinkedList<PlannedIss>();
    private List<PlannedLogError> plannedLogErrorList = new LinkedList<PlannedLogError>();

    public ISSTestingToolState(@NonNull Configuration configuration, @NonNull Metrics metrics) {
        super(configuration, metrics);
    }

    public ISSTestingToolState(@NonNull VirtualMap virtualMap) {
        super(virtualMap);
    }

    private ISSTestingToolState(ISSTestingToolState that) {
        super((VirtualMapState)that);
        this.runningSum = that.runningSum;
        this.genesisTimestamp = that.genesisTimestamp;
        this.plannedIssList = new ArrayList<PlannedIss>(that.plannedIssList);
        this.plannedLogErrorList = new ArrayList<PlannedLogError>(that.plannedLogErrorList);
    }

    protected ISSTestingToolState copyingConstructor() {
        return new ISSTestingToolState(this);
    }

    protected ISSTestingToolState newInstance(@NonNull VirtualMap virtualMap) {
        return new ISSTestingToolState(virtualMap);
    }

    public void initState(InitTrigger trigger, Platform platform) {
        this.throwIfImmutable();
        PlatformContext platformContext = platform.getContext();
        super.init(platformContext.getTime(), platformContext.getMetrics(), platformContext.getMerkleCryptography(), () -> PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf((State)this));
        V0680ISSTestingToolSchema schema = new V0680ISSTestingToolSchema();
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateId)).forEach(def -> super.initializeState(new StateMetadata("ISSTestingToolService", def)));
        if (trigger == InitTrigger.GENESIS) {
            ISSTestingToolConfig testingToolConfig = (ISSTestingToolConfig)platform.getContext().getConfiguration().getConfigData(ISSTestingToolConfig.class);
            this.plannedIssList = testingToolConfig.getPlannedISSs();
            this.plannedLogErrorList = testingToolConfig.getPlannedLogErrors();
            WritableStates writableStates = this.getWritableStates("ISSTestingToolService");
            WritableQueueState plannedIssState = writableStates.getQueue(3);
            this.plannedIssList.forEach(arg_0 -> ((WritableQueueState)plannedIssState).add(arg_0));
            WritableQueueState plannedLogErrorState = writableStates.getQueue(4);
            this.plannedLogErrorList.forEach(arg_0 -> ((WritableQueueState)plannedLogErrorState).add(arg_0));
            ((CommittableWritableStates)writableStates).commit();
        } else {
            ReadableSingletonState genesisTimestampState;
            ProtoString genesisTimestampString;
            ReadableStates readableStates = this.getReadableStates("ISSTestingToolService");
            ReadableSingletonState runningSumState = readableStates.getSingleton(1);
            ProtoLong runningSum = (ProtoLong)runningSumState.get();
            if (runningSum != null) {
                this.runningSum = runningSum.value();
            }
            if ((genesisTimestampString = (ProtoString)(genesisTimestampState = readableStates.getSingleton(2)).get()) != null) {
                this.genesisTimestamp = Instant.parse(genesisTimestampString.value());
            }
            ReadableQueueState plannedIssState = readableStates.getQueue(3);
            plannedIssState.iterator().forEachRemaining(plannedIss -> this.plannedIssList.add((PlannedIss)plannedIss));
            ReadableQueueState plannedLogErrorState = readableStates.getQueue(4);
            plannedLogErrorState.iterator().forEachRemaining(plannedLogError -> this.plannedLogErrorList.add((PlannedLogError)plannedLogError));
        }
    }

    void captureTimestamp(@NonNull ConsensusEvent event) {
        if (this.genesisTimestamp == null) {
            this.genesisTimestamp = event.getConsensusTimestamp();
            WritableSingletonState genesisTimestampState = this.getWritableStates("ISSTestingToolService").getSingleton(2);
            genesisTimestampState.put((Object)new ProtoString(this.genesisTimestamp.toString()));
            ((OnDiskWritableSingletonState)genesisTimestampState).commit();
        }
    }

    void incrementRunningSum(long delta) {
        this.runningSum += delta;
        WritableSingletonState runningSumState = this.getWritableStates("ISSTestingToolService").getSingleton(1);
        runningSumState.put((Object)new ProtoLong(this.runningSum));
        ((OnDiskWritableSingletonState)runningSumState).commit();
    }

    Instant getGenesisTimestamp() {
        return this.genesisTimestamp;
    }

    List<PlannedIss> getPlannedIssList() {
        return this.plannedIssList;
    }

    List<PlannedLogError> getPlannedLogErrorList() {
        return this.plannedLogErrorList;
    }
}

