/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import java.io.Serializable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractBatch;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.lazy.parallel.bag.CollectUnsortedBagBatch;
import org.eclipse.collections.impl.lazy.parallel.bag.FlatCollectUnsortedBagBatch;
import org.eclipse.collections.impl.lazy.parallel.bag.UnsortedBagBatch;
import org.eclipse.collections.impl.lazy.parallel.set.SelectUnsortedSetBatch;
import org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;

@Beta
public class DistinctBatch<T>
extends AbstractBatch<T>
implements UnsortedSetBatch<T> {
    private final Batch<T> batch;
    private final ConcurrentHashMap<T, Boolean> distinct;

    public DistinctBatch(Batch<T> batch, ConcurrentHashMap<T, Boolean> distinct) {
        this.batch = batch;
        this.distinct = distinct;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.batch.forEach((Procedure & Serializable)each -> {
            if (this.distinct.put(each, true) == null) {
                procedure.value(each);
            }
        });
    }

    @Override
    public UnsortedSetBatch<T> select(Predicate<? super T> predicate) {
        return new SelectUnsortedSetBatch<T>(this, predicate);
    }

    @Override
    public <V> UnsortedBagBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectUnsortedBagBatch<T, V>(this, function);
    }

    @Override
    public <V> UnsortedBagBatch<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectUnsortedBagBatch(this, function);
    }
}

