/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.stream.internal.AbstractLinkedObjectStream;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.logging.legacy.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.base.crypto.SerializableHashable;

public class RunningHashCalculatorForStream<T extends RunningHashable & SerializableHashable>
extends AbstractLinkedObjectStream<T> {
    private static final Logger logger = LogManager.getLogger(RunningHashCalculatorForStream.class);
    private static final Cryptography cryptography = CryptographyProvider.getInstance();
    private Hash runningHash;

    public RunningHashCalculatorForStream() {
    }

    public RunningHashCalculatorForStream(LinkedObjectStream<T> nextStream) {
        super(nextStream);
    }

    @Override
    public void addObject(T t) {
        if (((SerializableHashable)t).getHash() == null) {
            cryptography.digestSync((SerializableHashable)t);
        }
        Hash newHashToAdd = ((SerializableHashable)t).getHash();
        this.runningHash = cryptography.calcRunningHash(this.runningHash, newHashToAdd);
        t.getRunningHash().setHash(this.runningHash);
        super.addObject(t);
    }

    @Override
    public void close() {
        super.close();
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream is closed");
    }

    public Hash getRunningHash() {
        return this.runningHash;
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.runningHash = hash;
        super.setRunningHash(hash);
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream :: setRunningHash: {}", (Object)hash);
    }
}

