/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.CommandBuilder;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteFactory;
import com.swirlds.common.merkle.route.MerkleRouteUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateReference;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import picocli.CommandLine;

public class StateEditor {
    private final SignedStateReference signedState = new SignedStateReference();
    private MerkleRoute currentWorkingRoute = MerkleRouteFactory.getEmptyRoute();
    private boolean alive = true;
    private final PlatformContext platformContext;

    public StateEditor(Path statePath) throws IOException {
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
        this.platformContext = PlatformContext.create((Configuration)configuration);
        DeserializedSignedState deserializedSignedState = SignedStateFileReader.readStateFile(statePath, virtualMap -> {
            throw new UnsupportedOperationException();
        }, PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE, this.platformContext);
        try (ReservedSignedState reservedSignedState = deserializedSignedState.reservedSignedState();){
            System.out.println("\nLoading state from " + String.valueOf(statePath));
            this.signedState.set(reservedSignedState.get(), "StateEditor constructor");
            System.out.println("Hashing state");
            try {
                this.platformContext.getMerkleCryptography().digestTreeAsync(reservedSignedState.get().getState().getRoot()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("problem encountered while hashing state", e);
            }
            System.out.println("Hash = " + String.valueOf(reservedSignedState.get().getState().getHash()));
        }
    }

    private int executionStrategy(CommandLine.ParseResult parseResult) {
        Object command = parseResult.subcommand().commandSpec().commandLine().getCommand();
        if (command instanceof StateEditorOperation) {
            StateEditorOperation operation = (StateEditorOperation)command;
            operation.setStateEditor(this);
        }
        return new CommandLine.RunLast().execute(parseResult);
    }

    private CommandLine buildCommandLine() {
        CommandLine commandLine = CommandBuilder.buildCommandLine(StateEditorRoot.class);
        commandLine.setExecutionStrategy(this::executionStrategy);
        return commandLine;
    }

    public void start() {
        Scanner reader = new Scanner(System.in);
        CommandLine commandLine = this.buildCommandLine();
        System.out.println();
        commandLine.usage(System.out, commandLine.getColorScheme());
        while (this.alive) {
            MerkleNode target = null;
            while (true) {
                try (ReservedSignedState reservedSignedState = this.getState("StateEditor.start()");){
                    MerkleNode merkleTraversable = reservedSignedState.get().getState().getRoot();
                    target = merkleTraversable.getNodeAtRoute(this.currentWorkingRoute);
                }
                catch (NoSuchElementException e) {
                    this.currentWorkingRoute = this.currentWorkingRoute.getParent();
                    continue;
                }
                break;
            }
            System.out.print("\n" + StateEditorUtils.formatRoute(this.currentWorkingRoute) + " " + StateEditorUtils.formatNodeType(target) + " $ ");
            String command = reader.nextLine();
            String[] args = command.split(" ");
            try {
                int result = commandLine.execute(args);
                if (result != 0 && commandLine.getParseResult().subcommand() == null) {
                    System.out.println();
                    commandLine.usage(System.out, CommandBuilder.getColorScheme());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            commandLine = this.buildCommandLine();
        }
        reader.close();
    }

    public void exit() {
        this.alive = false;
    }

    public MerkleRoute getCurrentWorkingRoute() {
        return this.currentWorkingRoute;
    }

    public void setCurrentWorkingRoute(MerkleRoute currentWorkingRoute) {
        try (ReservedSignedState reservedSignedState = this.getState("StateEditor.setCurrentWorkingRoute()");){
            MerkleNode merkleTraversable = reservedSignedState.get().getState().getRoot();
            merkleTraversable.getNodeAtRoute(currentWorkingRoute);
            this.currentWorkingRoute = currentWorkingRoute;
        }
    }

    public ReservedSignedState getState(String reason) {
        return this.signedState.getAndReserve(reason);
    }

    public ReservedSignedState getSignedState() {
        return this.signedState.getAndReserve("StateEditor.getSignedState()");
    }

    public ReservedSignedState getSignedStateCopy() {
        try (ReservedSignedState reservedSignedState = this.signedState.getAndReserve("StateEditor.getSignedStateCopy() 1");){
            SignedState newSignedState = new SignedState(this.platformContext.getConfiguration(), CryptoStatic::verifySignature, reservedSignedState.get().getState().copy(), "StateEditor.getSignedStateCopy()", reservedSignedState.get().isFreezeState(), false, false, PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE);
            this.signedState.set(newSignedState, "StateEditor.getSignedStateCopy() 2");
            ReservedSignedState reservedSignedState2 = this.signedState.getAndReserve("StateEditor.getSignedStateCopy() return value");
            return reservedSignedState2;
        }
    }

    public MerkleNode getRelativeNode(String path) {
        try (ReservedSignedState reservedSignedState = this.getState("StateEditor.getRelativeNode()");){
            MerkleNode merkleTraversable = reservedSignedState.get().getState().getRoot();
            MerkleNode merkleNode = merkleTraversable.getNodeAtRoute(this.getRelativeRoute(path));
            return merkleNode;
        }
    }

    public MerkleRoute getRelativeRoute(String path) {
        return MerkleRouteUtils.pathFormatToMerkleRoute((MerkleRoute)this.getCurrentWorkingRoute(), (String)path);
    }

    public ParentInfo getParentInfo(String destinationPath) {
        MerkleRoute route = this.getRelativeRoute(destinationPath);
        MerkleRoute parentPath = route.getParent();
        int indexInParent = route.getStep(-1);
        try (ReservedSignedState reservedSignedState = this.signedState.getAndReserve("StateEditor.getParentInfo()");){
            MerkleNode merkleTraversable = reservedSignedState.get().getState().getRoot();
            MerkleNode parent = merkleTraversable.getNodeAtRoute(parentPath);
            if (parent == null) {
                throw new IllegalArgumentException("The node at " + StateEditorUtils.formatRoute(parentPath) + " is null.");
            }
            if (!(parent instanceof MerkleInternal)) {
                throw new IllegalArgumentException("The node at " + StateEditorUtils.formatRoute(parentPath) + " is of type " + parent.getClass().getSimpleName() + " and is not an internal node.");
            }
            ParentInfo parentInfo = new ParentInfo(route, parent.asInternal(), indexInParent);
            return parentInfo;
        }
    }

    public record ParentInfo(MerkleRoute target, MerkleInternal parent, int indexInParent) {
    }
}

