/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectLoadFailurePayload;
import com.swirlds.platform.reconnect.ReconnectPlatformHelper;
import com.swirlds.platform.reconnect.ReconnectUtils;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.state.MerkleNodeState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.Clearable;

public class ReconnectPlatformHelperImpl
implements ReconnectPlatformHelper {
    private static final Logger logger = LogManager.getLogger(ReconnectPlatformHelperImpl.class);
    private final Runnable pauseGossip;
    private final Clearable clearAll;
    private final Supplier<MerkleNodeState> workingStateSupplier;
    private final Consumer<SignedState> loadSignedState;
    private final MerkleCryptography merkleCryptography;

    public ReconnectPlatformHelperImpl(@NonNull Runnable pauseGossip, @NonNull Clearable clearAll, @NonNull Supplier<MerkleNodeState> workingStateSupplier, @NonNull Consumer<SignedState> loadSignedState, @NonNull MerkleCryptography merkleCryptography) {
        this.pauseGossip = pauseGossip;
        this.clearAll = clearAll;
        this.workingStateSupplier = workingStateSupplier;
        this.loadSignedState = loadSignedState;
        this.merkleCryptography = merkleCryptography;
    }

    @Override
    public void prepareForReconnect() {
        logger.info(LogMarker.RECONNECT.getMarker(), "Preparing for reconnect, stopping gossip");
        this.pauseGossip.run();
        logger.info(LogMarker.RECONNECT.getMarker(), "Preparing for reconnect, start clearing queues");
        this.clearAll.clear();
        logger.info(LogMarker.RECONNECT.getMarker(), "Queues have been cleared");
        ReconnectUtils.hashStateForReconnect(this.merkleCryptography, this.workingStateSupplier.get());
    }

    @Override
    public boolean loadSignedState(@NonNull SignedState signedState) {
        try {
            this.loadSignedState.accept(signedState);
        }
        catch (RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectLoadFailurePayload("Error while loading a received SignedState!").toString(), (Throwable)e);
            logger.debug(LogMarker.RECONNECT.getMarker(), "`reloadState` : reloading state, finished, failed, returning `false`: Restart the reconnection process");
            return false;
        }
        return true;
    }
}

