/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.StateCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.util.BootstrapUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="editor", mixinStandardHelpOptions=true, description={"Launch an interactive state editor."})
@SubcommandOf(value=StateCommand.class)
public class StateEditorCommand
extends AbstractCommand {
    private Path statePath;
    private List<Path> configurationPaths = List.of();

    @CommandLine.Parameters(description={"The path to the state to open with the editor"})
    private void setStatePath(Path statePath) {
        this.statePath = this.pathMustExist(statePath.toAbsolutePath());
    }

    @CommandLine.Option(names={"-c", "--config"}, description={"A path to where a configuration file can be found. If not provided then defaults are used."})
    private void setConfigurationPath(List<Path> configurationPaths) {
        configurationPaths.forEach(x$0 -> this.pathMustExist((Path)x$0));
        this.configurationPaths = configurationPaths;
    }

    public Integer call() throws IOException {
        DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create(), FileUtils.getAbsolutePath((String)"settings.txt"), this.configurationPaths);
        BootstrapUtils.setupConstructableRegistry();
        new StateEditor(this.statePath).start();
        return 0;
    }
}

