/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.stream;

import com.swirlds.common.test.fixtures.stream.ObjectForTestStream;
import java.time.Instant;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectForTestStreamGenerator {
    private int totalNum;
    private int intervalMs;
    private Instant nextTimestamp;
    private int idx;

    public ObjectForTestStreamGenerator(int totalNum, int intervalMs, Instant firstTimestamp) {
        this.totalNum = totalNum;
        this.intervalMs = intervalMs;
        this.nextTimestamp = firstTimestamp;
    }

    public Iterator<ObjectForTestStream> getIterator() {
        return new Iterator<ObjectForTestStream>(){

            @Override
            public boolean hasNext() {
                return ObjectForTestStreamGenerator.this.idx < ObjectForTestStreamGenerator.this.totalNum;
            }

            @Override
            public ObjectForTestStream next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ObjectForTestStream object = new ObjectForTestStream(ObjectForTestStreamGenerator.this.idx, ObjectForTestStreamGenerator.this.nextTimestamp);
                ++ObjectForTestStreamGenerator.this.idx;
                ObjectForTestStreamGenerator.this.nextTimestamp = ObjectForTestStreamGenerator.this.nextTimestamp.plusMillis(ObjectForTestStreamGenerator.this.intervalMs);
                return object;
            }
        };
    }
}

