/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.demo.iss.PlannedIncident;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.model.node.NodeId;

public class PlannedLogError
implements PlannedIncident {
    private Duration timeAfterGenesis;
    private List<NodeId> nodeIds;

    public PlannedLogError() {
    }

    public PlannedLogError(@NonNull Duration timeAfterGenesis, @NonNull List<NodeId> nodeIds) {
        this.timeAfterGenesis = Objects.requireNonNull(timeAfterGenesis);
        this.nodeIds = Objects.requireNonNull(nodeIds);
    }

    public PlannedLogError(@NonNull ReadableSequentialData in) {
        this.timeAfterGenesis = Duration.ofNanos(in.readLong());
        int nodeCount = in.readInt();
        this.nodeIds = new ArrayList<NodeId>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            this.nodeIds.add(NodeId.of((long)in.readLong()));
        }
    }

    public void writeTo(@NonNull WritableSequentialData output) {
        output.writeLong(this.timeAfterGenesis.toNanos());
        output.writeInt(this.nodeIds.size());
        for (NodeId nodeId : this.nodeIds) {
            output.writeLong(nodeId.id());
        }
    }

    public int getSizeInBytes() {
        int sizeInBytes = 0;
        sizeInBytes += 8;
        sizeInBytes += 4;
        for (NodeId ignored : this.nodeIds) {
            sizeInBytes += 8;
        }
        return sizeInBytes;
    }

    @NonNull
    public static PlannedLogError fromString(@NonNull String plannedLogErrorString) {
        String[] timestampAndNodesStrings = plannedLogErrorString.strip().split(":");
        int elapsedSeconds = Integer.parseInt(timestampAndNodesStrings[0]);
        String[] nodeIdsStrings = timestampAndNodesStrings[1].split("-");
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>();
        for (String nodeIdString : nodeIdsStrings) {
            nodeIds.add(NodeId.of((long)Integer.parseInt(nodeIdString)));
        }
        return new PlannedLogError(Duration.ofSeconds(elapsedSeconds), nodeIds);
    }

    @Override
    @NonNull
    public Duration getTimeAfterGenesis() {
        return this.timeAfterGenesis;
    }

    @Override
    @NonNull
    public String getDescriptor() {
        return "Log Error";
    }

    @NonNull
    public List<NodeId> getNodeIds() {
        return Collections.unmodifiableList(this.nodeIds);
    }
}

