/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.output.codec;

import com.hedera.hapi.block.stream.output.BlockHeader;
import com.hedera.hapi.node.base.BlockHashAlgorithm;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BlockHeaderJsonCodec
implements JsonCodec<BlockHeader> {
    @NonNull
    public BlockHeader parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            SemanticVersion temp_hapi_proto_version = null;
            SemanticVersion temp_software_version = null;
            long temp_number = 0L;
            Timestamp temp_block_timestamp = null;
            BlockHashAlgorithm temp_hash_algorithm = BlockHashAlgorithm.fromProtobufOrdinal(0);
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "hapiProtoVersion": {
                        temp_hapi_proto_version = (SemanticVersion)SemanticVersion.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "softwareVersion": {
                        temp_software_version = (SemanticVersion)SemanticVersion.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "number": {
                        temp_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "blockTimestamp": {
                        temp_block_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "hashAlgorithm": {
                        temp_hash_algorithm = BlockHashAlgorithm.fromString(kvPair.value().STRING().getText());
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockHeader(temp_hapi_proto_version, temp_software_version, temp_number, temp_block_timestamp, temp_hash_algorithm);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockHeader data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.hapiProtoVersion() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"hapiProtoVersion", SemanticVersion.JSON, (Object)data.hapiProtoVersion()));
        }
        if (data.softwareVersion() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"softwareVersion", SemanticVersion.JSON, (Object)data.softwareVersion()));
        }
        if (data.number() != 0L) {
            fieldLines.add(JsonTools.field((String)"number", (long)data.number()));
        }
        if (data.blockTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockTimestamp", Timestamp.JSON, (Object)data.blockTimestamp()));
        }
        if (data.hashAlgorithm() != BlockHashAlgorithm.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"hashAlgorithm", (String)data.hashAlgorithm().protoName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

