/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class SignedTransactionJsonCodec
implements JsonCodec<SignedTransaction> {
    @NonNull
    public SignedTransaction parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_bodyBytes = Bytes.EMPTY;
            SignatureMap temp_sigMap = null;
            boolean temp_use_serialized_tx_message_hash_algorithm = false;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "bodyBytes": {
                        temp_bodyBytes = Bytes.fromBase64((String)JsonTools.checkSize((String)"bodyBytes", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "sigMap": {
                        temp_sigMap = (SignatureMap)SignatureMap.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block12;
                    }
                    case "useSerializedTxMessageHashAlgorithm": {
                        temp_use_serialized_tx_message_hash_algorithm = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new SignedTransaction(temp_bodyBytes, temp_sigMap, temp_use_serialized_tx_message_hash_algorithm);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull SignedTransaction data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.bodyBytes() != Bytes.EMPTY && data.bodyBytes() != null && data.bodyBytes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"bodyBytes", (Bytes)data.bodyBytes()));
        }
        if (data.sigMap() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"sigMap", SignatureMap.JSON, (Object)data.sigMap()));
        }
        if (data.useSerializedTxMessageHashAlgorithm()) {
            fieldLines.add(JsonTools.field((String)"useSerializedTxMessageHashAlgorithm", (boolean)data.useSerializedTxMessageHashAlgorithm()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

